/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.jvm.AbstractJVMRecord;
import kieker.common.util.registry.IRegistry;

public class ClassLoadingRecord
extends AbstractJVMRecord {
    public static final int SIZE = 36;
    private static final long serialVersionUID = -2006121738839922850L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Long.TYPE, Integer.TYPE, Long.TYPE};
    private final long totalLoadedClassCount;
    private final int loadedClassCount;
    private final long unloadedClassCount;

    public ClassLoadingRecord(long timestamp, String hostname, String vmName, long totalLoadedClassCount, int loadedClassCount, long unloadedClassCount) {
        super(timestamp, hostname, vmName);
        this.totalLoadedClassCount = totalLoadedClassCount;
        this.loadedClassCount = loadedClassCount;
        this.unloadedClassCount = unloadedClassCount;
    }

    public ClassLoadingRecord(Object[] values) {
        super(values, TYPES);
        this.totalLoadedClassCount = (Long)values[3];
        this.loadedClassCount = (Integer)values[4];
        this.unloadedClassCount = (Long)values[5];
    }

    protected ClassLoadingRecord(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.totalLoadedClassCount = (Long)values[3];
        this.loadedClassCount = (Integer)values[4];
        this.unloadedClassCount = (Long)values[5];
    }

    public ClassLoadingRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.totalLoadedClassCount = buffer.getLong();
        this.loadedClassCount = buffer.getInt();
        this.unloadedClassCount = buffer.getLong();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getHostname(), this.getVmName(), this.getTotalLoadedClassCount(), this.getLoadedClassCount(), this.getUnloadedClassCount()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(stringRegistry.get(this.getVmName()));
        buffer.putLong(this.getTotalLoadedClassCount());
        buffer.putInt(this.getLoadedClassCount());
        buffer.putLong(this.getUnloadedClassCount());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getTotalLoadedClassCount() {
        return this.totalLoadedClassCount;
    }

    public final int getLoadedClassCount() {
        return this.loadedClassCount;
    }

    public final long getUnloadedClassCount() {
        return this.unloadedClassCount;
    }
}

