/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation.object;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.flow.IObjectRecord;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.util.registry.IRegistry;

public class AfterOperationFailedObjectEvent
extends AfterOperationFailedEvent
implements IObjectRecord {
    public static final int SIZE = 36;
    private static final long serialVersionUID = 5675043694442669903L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class, Integer.TYPE};
    private final int objectId;

    public AfterOperationFailedObjectEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String cause, int objectId) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature, cause);
        this.objectId = objectId;
    }

    public AfterOperationFailedObjectEvent(Object[] values) {
        super(values, TYPES);
        this.objectId = (Integer)values[6];
    }

    protected AfterOperationFailedObjectEvent(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.objectId = (Integer)values[6];
    }

    public AfterOperationFailedObjectEvent(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.objectId = buffer.getInt();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getTraceId(), this.getOrderIndex(), this.getOperationSignature(), this.getClassSignature(), this.getCause(), this.getObjectId()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putLong(this.getTraceId());
        buffer.putInt(this.getOrderIndex());
        buffer.putInt(stringRegistry.get(this.getOperationSignature()));
        buffer.putInt(stringRegistry.get(this.getClassSignature()));
        buffer.putInt(stringRegistry.get(this.getCause()));
        buffer.putInt(this.getObjectId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getObjectId() {
        return this.objectId;
    }
}

