/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib.forecast.mean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kieker.tools.tslib.ForecastMethod;
import kieker.tools.tslib.ITimeSeries;
import kieker.tools.tslib.forecast.AbstractForecaster;
import kieker.tools.tslib.forecast.ForecastResult;
import kieker.tools.tslib.forecast.IForecastResult;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.StatUtils;

public class MeanForecasterJava
extends AbstractForecaster<Double> {
    public MeanForecasterJava(ITimeSeries<Double> historyTimeseries) {
        super(historyTimeseries);
    }

    @Override
    public IForecastResult forecast(int numForecastSteps) {
        ITimeSeries history = this.getTsOriginal();
        ITimeSeries<Double> tsFC = this.prepareForecastTS();
        ArrayList<Double> allHistory = new ArrayList<Double>(history.getValues());
        Double[] histValuesNotNull = MeanForecasterJava.removeNullValues(allHistory);
        double mean = StatUtils.mean((double[])ArrayUtils.toPrimitive((Double[])histValuesNotNull));
        Object[] forecastValues = new Double[numForecastSteps];
        Arrays.fill(forecastValues, (Object)mean);
        tsFC.appendAll(forecastValues);
        return new ForecastResult(tsFC, this.getTsOriginal(), ForecastMethod.MEAN);
    }

    public static Double[] removeNullValues(List<Double> allHistory) {
        ArrayList<Double> newList = new ArrayList<Double>();
        for (Double obj : allHistory) {
            if (null == obj || !(obj instanceof Double) || Double.isNaN(obj)) continue;
            newList.add(obj);
        }
        return newList.toArray(new Double[newList.size()]);
    }
}

