/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib.forecast;

import java.util.ArrayList;
import java.util.List;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.tslib.ForecastMethod;
import kieker.tools.tslib.ITimeSeries;
import kieker.tools.tslib.forecast.AbstractForecaster;
import kieker.tools.tslib.forecast.ForecastResult;
import kieker.tools.tslib.forecast.IForecastResult;
import kieker.tools.util.RBridgeControl;
import org.apache.commons.lang3.ArrayUtils;
import org.rosuda.REngine.REXPLogical;

public abstract class AbstractRForecaster
extends AbstractForecaster<Double> {
    private static final Log LOG = LogFactory.getLog(AbstractRForecaster.class);
    private static final RBridgeControl RBRIDGE = RBridgeControl.getInstance();
    private static boolean forecastPackageAvailable;
    private final String modelFunc;
    private final String forecastFunc;
    private final ForecastMethod strategy;

    public AbstractRForecaster(ITimeSeries<Double> historyTimeseries, String modelFunc, String forecastFunc, ForecastMethod strategy) {
        super(historyTimeseries);
        this.modelFunc = modelFunc;
        this.forecastFunc = forecastFunc;
        this.strategy = strategy;
        if (!forecastPackageAvailable) {
            this.logForecastModuleNotAvailableOrLoaded();
        }
    }

    public AbstractRForecaster(ITimeSeries<Double> historyTimeseries, String modelFunc, String forecastFunc, int confidenceLevel, ForecastMethod strategy) {
        super(historyTimeseries, confidenceLevel);
        this.modelFunc = modelFunc;
        this.forecastFunc = forecastFunc;
        this.strategy = strategy;
        if (!forecastPackageAvailable) {
            this.logForecastModuleNotAvailableOrLoaded();
        }
    }

    private static void setForecastModuleAvailableAndLoadedFlag(Object forecastPackageLoadResult) {
        if (forecastPackageLoadResult instanceof REXPLogical) {
            REXPLogical returnValue = (REXPLogical)forecastPackageLoadResult;
            boolean hasAttr = returnValue.hasAttribute("attr");
            boolean[] istrue = returnValue.isTRUE();
            if (!hasAttr && istrue.length > 0 && istrue[0]) {
                forecastPackageAvailable = false;
                return;
            }
        }
        forecastPackageAvailable = true;
    }

    private void logForecastModuleNotAvailableOrLoaded() {
        IllegalStateException ise = new IllegalStateException("\"forecast\" package could not be loaded in R.");
        LOG.error("Could not load \"forecast\" package in R. Perhaps it is not installed in R?", ise);
    }

    @Override
    public final IForecastResult forecast(int numForecastSteps) {
        ITimeSeries<Double> tsUpper;
        ITimeSeries<Double> tsLower;
        ITimeSeries history = this.getTsOriginal();
        String varNameValues = RBridgeControl.uniqueVarname();
        String varNameModel = RBridgeControl.uniqueVarname();
        String varNameForecast = RBridgeControl.uniqueVarname();
        ArrayList<Double> allHistory = new ArrayList<Double>(history.getValues());
        Double[] histValuesNotNull = AbstractRForecaster.removeNullValues(allHistory);
        double[] values = ArrayUtils.toPrimitive((Double[])histValuesNotNull);
        RBRIDGE.assign(varNameValues, values);
        if (history.getFrequency() != 0) {
            if (this.strategy != ForecastMethod.ARIMA) {
                RBRIDGE.toTS(varNameValues, history.getFrequency());
            } else {
                RBRIDGE.toTS(varNameValues);
            }
        }
        if (this.modelFunc == null) {
            RBRIDGE.assign(varNameModel, values);
            if (history.getFrequency() != 0) {
                if (this.strategy != ForecastMethod.ARIMA) {
                    RBRIDGE.toTS(varNameValues, history.getFrequency());
                } else {
                    RBRIDGE.toTS(varNameValues);
                }
            }
        } else {
            String[] additionalModelParams = this.getModelFuncParams();
            StringBuffer params = new StringBuffer();
            params.append(varNameValues);
            if (null != additionalModelParams) {
                for (String param : additionalModelParams) {
                    params.append(',');
                    params.append(param);
                }
            }
            RBRIDGE.evalWithR(String.format("%s <<- %s(%s)", varNameModel, this.modelFunc, params));
        }
        RBRIDGE.evalWithR(String.format("rm(%s)", varNameValues));
        if (this.getConfidenceLevel() == 0) {
            RBRIDGE.evalWithR(String.format("%s <<- %s(%s, h=%d)", varNameForecast, this.forecastFunc, varNameModel, numForecastSteps));
        } else {
            RBRIDGE.evalWithR(String.format("%s <<- %s(%s, h=%d, level=c(%d))", varNameForecast, this.forecastFunc, varNameModel, numForecastSteps, this.getConfidenceLevel()));
        }
        double[] lowerValues = RBRIDGE.eDblArr(this.lowerOperationOnResult(varNameForecast));
        double[] forecastValues = RBRIDGE.eDblArr(this.forecastOperationOnResult(varNameForecast));
        double[] upperValues = RBRIDGE.eDblArr(this.upperOperationOnResult(varNameForecast));
        double fcQuality = Double.NaN;
        if (forecastValues.length > 0) {
            fcQuality = this.modelFunc == null ? RBRIDGE.eDbl("accuracy(" + varNameForecast + ")[6]") : RBRIDGE.eDbl("accuracy(" + varNameModel + ")[6]");
        }
        RBRIDGE.evalWithR(String.format("rm(%s)", varNameModel));
        RBRIDGE.evalWithR(String.format("rm(%s)", varNameValues));
        RBRIDGE.evalWithR(String.format("rm(%s)", varNameForecast));
        ITimeSeries<Double> tsForecast = this.prepareForecastTS();
        tsForecast.appendAll(ArrayUtils.toObject((double[])forecastValues));
        if (this.getConfidenceLevel() == 0) {
            tsLower = tsForecast;
            tsUpper = tsForecast;
        } else {
            tsLower = this.prepareForecastTS();
            tsLower.appendAll(ArrayUtils.toObject((double[])lowerValues));
            tsUpper = this.prepareForecastTS();
            tsUpper.appendAll(ArrayUtils.toObject((double[])upperValues));
        }
        return new ForecastResult(tsForecast, this.getTsOriginal(), this.getConfidenceLevel(), fcQuality, tsLower, tsUpper, this.strategy);
    }

    protected String lowerOperationOnResult(String varNameForecast) {
        return String.format("%s$lower", varNameForecast);
    }

    protected String upperOperationOnResult(String varNameForecast) {
        return String.format("%s$upper", varNameForecast);
    }

    protected String forecastOperationOnResult(String varNameForecast) {
        return String.format("%s$mean", varNameForecast);
    }

    protected abstract String[] getModelFuncParams();

    protected abstract String[] getForecastFuncParams();

    public static Double[] removeNullValues(List<Double> allHistory) {
        ArrayList<Double> newList = new ArrayList<Double>();
        for (Double obj : allHistory) {
            if (null == obj || !(obj instanceof Double)) continue;
            newList.add(obj);
        }
        return newList.toArray(new Double[newList.size()]);
    }

    static {
        Object forecastPackageLoadResult = RBRIDGE.evalWithR("require(forecast)");
        AbstractRForecaster.setForecastModuleAvailableAndLoadedFlag(forecastPackageLoadResult);
    }
}

