/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.gui.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.text.JTextComponent;

public final class FileChooserActionListener
implements ActionListener {
    private final JFileChooser fileChooser = new JFileChooser();
    private final JTextComponent textComponent;
    private final int selectionMode;
    private final Component parent;

    private FileChooserActionListener(JTextComponent textComponent, int selectionMode, Component parent) {
        this.textComponent = textComponent;
        this.selectionMode = selectionMode;
        this.parent = parent;
    }

    public static FileChooserActionListener createFileChooserActionListener(JTextComponent textComponent, Component parent) {
        return new FileChooserActionListener(textComponent, 0, parent);
    }

    public static FileChooserActionListener createDirectoryChooserActionListener(JTextComponent textComponent, Component parent) {
        return new FileChooserActionListener(textComponent, 1, parent);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.initializeFileChooser();
        this.showFileChooser();
    }

    private void initializeFileChooser() {
        String currentPath = this.textComponent.getText();
        if (null == currentPath) {
            this.fileChooser.setCurrentDirectory(null);
        } else {
            this.fileChooser.setCurrentDirectory(new File(currentPath));
        }
    }

    private void showFileChooser() {
        this.fileChooser.setFileSelectionMode(this.selectionMode);
        int returnState = this.fileChooser.showOpenDialog(this.parent);
        if (0 == returnState) {
            File selectedFile = this.fileChooser.getSelectedFile();
            String selectedFilePath = selectedFile.getAbsolutePath();
            this.textComponent.setText(selectedFilePath);
        }
    }
}

