/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.dependencyGraph;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFilter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.DependencyGraphNode;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.OperationAllocationDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.traceAnalysis.systemModel.AbstractMessage;
import kieker.tools.traceAnalysis.systemModel.AllocationComponent;
import kieker.tools.traceAnalysis.systemModel.MessageTrace;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.SynchronousReplyMessage;
import kieker.tools.traceAnalysis.systemModel.repository.AllocationComponentOperationPairFactory;
import kieker.tools.traceAnalysis.systemModel.repository.AllocationRepository;
import kieker.tools.traceAnalysis.systemModel.repository.OperationRepository;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.traceAnalysis.systemModel.util.AllocationComponentOperationPair;

@Plugin(repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)}, outputPorts={@OutputPort(name="graphs", eventTypes={AbstractGraph.class})})
public class OperationDependencyGraphAllocationFilter
extends AbstractDependencyGraphFilter<AllocationComponentOperationPair> {
    private static final String CONFIGURATION_NAME = "Operation dependency graph (deployment level)";

    public OperationDependencyGraphAllocationFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext, new OperationAllocationDependencyGraph(new AllocationComponentOperationPair(0, OperationRepository.ROOT_OPERATION, AllocationRepository.ROOT_ALLOCATION_COMPONENT)));
    }

    @Override
    @InputPort(name="messageTraces", description="Receives the message traces to be processed", eventTypes={MessageTrace.class})
    public void inputMessageTraces(MessageTrace t) {
        for (AbstractMessage m : t.getSequenceAsVector()) {
            if (m instanceof SynchronousReplyMessage) continue;
            AllocationComponent senderComponent = m.getSendingExecution().getAllocationComponent();
            AllocationComponent receiverComponent = m.getReceivingExecution().getAllocationComponent();
            int rootOperationId = OperationRepository.ROOT_OPERATION.getId();
            Operation senderOperation = m.getSendingExecution().getOperation();
            Operation receiverOperation = m.getReceivingExecution().getOperation();
            AllocationComponentOperationPairFactory pairFactory = this.getSystemEntityFactory().getAllocationPairFactory();
            AllocationComponentOperationPair senderPair = senderOperation.getId() == rootOperationId ? (AllocationComponentOperationPair)((AbstractDependencyGraph)this.getGraph()).getRootNode().getEntity() : pairFactory.getPairInstanceByPair(senderComponent, senderOperation);
            AllocationComponentOperationPair receiverPair = receiverOperation.getId() == rootOperationId ? (AllocationComponentOperationPair)((AbstractDependencyGraph)this.getGraph()).getRootNode().getEntity() : pairFactory.getPairInstanceByPair(receiverComponent, receiverOperation);
            DependencyGraphNode<Object> senderNode = ((AbstractDependencyGraph)this.getGraph()).getNode(senderPair.getId());
            DependencyGraphNode<Object> receiverNode = ((AbstractDependencyGraph)this.getGraph()).getNode(receiverPair.getId());
            if (senderNode == null) {
                senderNode = new DependencyGraphNode<AllocationComponentOperationPair>(senderPair.getId(), senderPair, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getSendingExecution().isAssumed()) {
                    senderNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(senderNode.getId(), senderNode);
            } else {
                this.handleOrigin(senderNode, t.getTraceInformation());
            }
            if (receiverNode == null) {
                receiverNode = new DependencyGraphNode<AllocationComponentOperationPair>(receiverPair.getId(), receiverPair, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getReceivingExecution().isAssumed()) {
                    receiverNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(receiverNode.getId(), receiverNode);
            } else {
                this.handleOrigin(receiverNode, t.getTraceInformation());
            }
            boolean assumed = this.isDependencyAssumed(senderNode, receiverNode);
            senderNode.addOutgoingDependency(receiverNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            receiverNode.addIncomingDependency(senderNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            this.invokeDecorators(m, senderNode, receiverNode);
        }
        this.reportSuccess(t.getTraceId());
    }

    @Override
    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }
}

