/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.dependencyGraph;

import kieker.tools.traceAnalysis.filter.visualization.AbstractGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFormatter;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.AbstractDependencyGraphFormatterVisitor;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.ContainerDependencyGraph;
import kieker.tools.traceAnalysis.filter.visualization.dependencyGraph.DependencyGraphNode;
import kieker.tools.traceAnalysis.filter.visualization.util.dot.DotFactory;
import kieker.tools.traceAnalysis.systemModel.ExecutionContainer;

public class ContainerDependencyGraphFormatter
extends AbstractDependencyGraphFormatter<ContainerDependencyGraph> {
    private static final String DEFAULT_FILE_NAME = "containerDependencyGraph.dot";

    static String createExecutionContainerNodeLabel(ExecutionContainer container) {
        return "<<execution container>>\\n" + container.getName();
    }

    @Override
    protected String formatDependencyGraph(ContainerDependencyGraph graph, boolean includeWeights, boolean useShortLabels, boolean plotLoops) {
        StringBuilder builder = new StringBuilder();
        this.appendGraphHeader(builder);
        graph.traverseWithVerticesFirst(new FormatterVisitor(builder, includeWeights, plotLoops, useShortLabels));
        this.appendGraphFooter(builder);
        return builder.toString();
    }

    @Override
    public String getDefaultFileName() {
        return DEFAULT_FILE_NAME;
    }

    private static class FormatterVisitor
    extends AbstractDependencyGraphFormatterVisitor<ExecutionContainer> {
        public FormatterVisitor(StringBuilder builder, boolean includeWeights, boolean plotLoops, boolean useShortLabels) {
            super(builder, includeWeights, plotLoops, useShortLabels);
        }

        @Override
        public void visitVertex(DependencyGraphNode<ExecutionContainer> vertex) {
            ExecutionContainer container = vertex.getEntity();
            if (container.isRootContainer()) {
                this.builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(vertex), container.getName(), "none", null, null, null, null, 0.0, null, null, null));
            } else {
                this.builder.append((CharSequence)DotFactory.createNode("", AbstractDependencyGraphFormatter.createNodeId(vertex), ContainerDependencyGraphFormatter.createExecutionContainerNodeLabel(container), "box3d", "filled", AbstractGraphFormatter.getDotRepresentation(vertex.getColor()), "white", null, 0.0, null, null, vertex.getDescription()));
            }
            this.builder.append("\n");
        }
    }
}

