/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.sigar.samplers;

import kieker.common.record.system.ResourceUtilizationRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.sigar.samplers.AbstractSigarSampler;
import kieker.monitoring.timer.ITimeSource;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public class CPUsCombinedPercSampler
extends AbstractSigarSampler {
    private static final String CPU_RESOURCE_NAME_PREFIX = "cpu-";

    public CPUsCombinedPercSampler(SigarProxy sigar) {
        super(sigar);
    }

    @Override
    public void sample(IMonitoringController monitoringController) throws SigarException {
        if (!monitoringController.isMonitoringEnabled()) {
            return;
        }
        if (!monitoringController.isProbeActivated(SignatureFactory.createCPUSignature())) {
            return;
        }
        CpuPerc[] cpus = this.sigar.getCpuPercList();
        ITimeSource timesource = monitoringController.getTimeSource();
        for (int i = 0; i < cpus.length; ++i) {
            if (!monitoringController.isProbeActivated(SignatureFactory.createCPUSignature(i))) continue;
            CpuPerc curCPU = cpus[i];
            double combinedUtilization = curCPU.getCombined();
            ResourceUtilizationRecord r = new ResourceUtilizationRecord(timesource.getTime(), monitoringController.getHostname(), CPU_RESOURCE_NAME_PREFIX + i, combinedUtilization);
            monitoringController.newMonitoringRecord(r);
        }
    }
}

