/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.sigar;

import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.monitoring.sampler.sigar.ISigarSamplerFactory;
import kieker.monitoring.sampler.sigar.samplers.CPUsCombinedPercSampler;
import kieker.monitoring.sampler.sigar.samplers.CPUsDetailedPercSampler;
import kieker.monitoring.sampler.sigar.samplers.MemSwapUsageSampler;
import org.hyperic.sigar.Humidor;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarProxy;

public enum SigarSamplerFactory implements ISigarSamplerFactory
{
    INSTANCE;

    private final SigarProxy sigar;

    private SigarSamplerFactory() {
        Log log = LogFactory.getLog(SigarSamplerFactory.class);
        Sigar mySigar = new Sigar();
        if (mySigar.getNativeLibrary() == null) {
            log.error("No Sigar native lib in java.library.path. See Sigar log for details (maybe only visible on Debug log-level).");
        }
        Humidor humidor = new Humidor(mySigar);
        this.sigar = humidor.getSigar();
    }

    public final SigarProxy getSigar() {
        return this.sigar;
    }

    @Override
    public CPUsCombinedPercSampler createSensorCPUsCombinedPerc() {
        return new CPUsCombinedPercSampler(this.sigar);
    }

    @Override
    public CPUsDetailedPercSampler createSensorCPUsDetailedPerc() {
        return new CPUsDetailedPercSampler(this.sigar);
    }

    @Override
    public MemSwapUsageSampler createSensorMemSwapUsage() {
        return new MemSwapUsageSampler(this.sigar);
    }
}

