/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class MemSwapUsageRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 60;
    private static final long serialVersionUID = 7372856570663572439L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final long MEM_TOTAL = 0L;
    public static final long MEM_USED = 0L;
    public static final long MEM_FREE = 0L;
    public static final long SWAP_TOTAL = 0L;
    public static final long SWAP_USED = 0L;
    public static final long SWAP_FREE = 0L;
    private final long timestamp;
    private final String hostname;
    private final long memTotal;
    private final long memUsed;
    private final long memFree;
    private final long swapTotal;
    private final long swapUsed;
    private final long swapFree;

    public MemSwapUsageRecord(long timestamp, String hostname, long memTotal, long memUsed, long memFree, long swapTotal, long swapUsed, long swapFree) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? HOSTNAME : hostname;
        this.memTotal = memTotal;
        this.memUsed = memUsed;
        this.memFree = memFree;
        this.swapTotal = swapTotal;
        this.swapUsed = swapUsed;
        this.swapFree = swapFree;
    }

    public MemSwapUsageRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.memTotal = (Long)values[2];
        this.memUsed = (Long)values[3];
        this.memFree = (Long)values[4];
        this.swapTotal = (Long)values[5];
        this.swapUsed = (Long)values[6];
        this.swapFree = (Long)values[7];
    }

    protected MemSwapUsageRecord(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.memTotal = (Long)values[2];
        this.memUsed = (Long)values[3];
        this.memFree = (Long)values[4];
        this.swapTotal = (Long)values[5];
        this.swapUsed = (Long)values[6];
        this.swapFree = (Long)values[7];
    }

    public MemSwapUsageRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.timestamp = buffer.getLong();
        this.hostname = stringRegistry.get(buffer.getInt());
        this.memTotal = buffer.getLong();
        this.memUsed = buffer.getLong();
        this.memFree = buffer.getLong();
        this.swapTotal = buffer.getLong();
        this.swapUsed = buffer.getLong();
        this.swapFree = buffer.getLong();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getHostname(), this.getMemTotal(), this.getMemUsed(), this.getMemFree(), this.getSwapTotal(), this.getSwapUsed(), this.getSwapFree()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putLong(this.getMemTotal());
        buffer.putLong(this.getMemUsed());
        buffer.putLong(this.getMemFree());
        buffer.putLong(this.getSwapTotal());
        buffer.putLong(this.getSwapUsed());
        buffer.putLong(this.getSwapFree());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 60;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final long getMemTotal() {
        return this.memTotal;
    }

    public final long getMemUsed() {
        return this.memUsed;
    }

    public final long getMemFree() {
        return this.memFree;
    }

    public final long getSwapTotal() {
        return this.swapTotal;
    }

    public final long getSwapUsed() {
        return this.swapUsed;
    }

    public final long getSwapFree() {
        return this.swapFree;
    }
}

