/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.jvm.AbstractJVMRecord;
import kieker.common.util.registry.IRegistry;

public class ThreadsStatusRecord
extends AbstractJVMRecord {
    public static final int SIZE = 48;
    private static final long serialVersionUID = 2792503169060556644L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE};
    private final long threadCount;
    private final long daemonThreadCount;
    private final long peakThreadCount;
    private final long totalStartedThreadCount;

    public ThreadsStatusRecord(long timestamp, String hostname, String vmName, long threadCount, long daemonThreadCount, long peakThreadCount, long totalStartedThreadCount) {
        super(timestamp, hostname, vmName);
        this.threadCount = threadCount;
        this.daemonThreadCount = daemonThreadCount;
        this.peakThreadCount = peakThreadCount;
        this.totalStartedThreadCount = totalStartedThreadCount;
    }

    public ThreadsStatusRecord(Object[] values) {
        super(values, TYPES);
        this.threadCount = (Long)values[3];
        this.daemonThreadCount = (Long)values[4];
        this.peakThreadCount = (Long)values[5];
        this.totalStartedThreadCount = (Long)values[6];
    }

    protected ThreadsStatusRecord(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.threadCount = (Long)values[3];
        this.daemonThreadCount = (Long)values[4];
        this.peakThreadCount = (Long)values[5];
        this.totalStartedThreadCount = (Long)values[6];
    }

    public ThreadsStatusRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.threadCount = buffer.getLong();
        this.daemonThreadCount = buffer.getLong();
        this.peakThreadCount = buffer.getLong();
        this.totalStartedThreadCount = buffer.getLong();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getHostname(), this.getVmName(), this.getThreadCount(), this.getDaemonThreadCount(), this.getPeakThreadCount(), this.getTotalStartedThreadCount()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(stringRegistry.get(this.getVmName()));
        buffer.putLong(this.getThreadCount());
        buffer.putLong(this.getDaemonThreadCount());
        buffer.putLong(this.getPeakThreadCount());
        buffer.putLong(this.getTotalStartedThreadCount());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 48;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getThreadCount() {
        return this.threadCount;
    }

    public final long getDaemonThreadCount() {
        return this.daemonThreadCount;
    }

    public final long getPeakThreadCount() {
        return this.peakThreadCount;
    }

    public final long getTotalStartedThreadCount() {
        return this.totalStartedThreadCount;
    }
}

