/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.jvm.AbstractJVMRecord;
import kieker.common.util.registry.IRegistry;

public class MemoryRecord
extends AbstractJVMRecord {
    public static final int SIZE = 84;
    private static final long serialVersionUID = 3895659770245456299L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE};
    private final long heapMaxBytes;
    private final long heapUsedBytes;
    private final long heapCommittedBytes;
    private final long heapInitBytes;
    private final long nonHeapMaxBytes;
    private final long nonHeapUsedBytes;
    private final long nonHeapCommittedBytes;
    private final long nonHeapInitBytes;
    private final int objectPendingFinalizationCount;

    public MemoryRecord(long timestamp, String hostname, String vmName, long heapMaxBytes, long heapUsedBytes, long heapCommittedBytes, long heapInitBytes, long nonHeapMaxBytes, long nonHeapUsedBytes, long nonHeapCommittedBytes, long nonHeapInitBytes, int objectPendingFinalizationCount) {
        super(timestamp, hostname, vmName);
        this.heapMaxBytes = heapMaxBytes;
        this.heapUsedBytes = heapUsedBytes;
        this.heapCommittedBytes = heapCommittedBytes;
        this.heapInitBytes = heapInitBytes;
        this.nonHeapMaxBytes = nonHeapMaxBytes;
        this.nonHeapUsedBytes = nonHeapUsedBytes;
        this.nonHeapCommittedBytes = nonHeapCommittedBytes;
        this.nonHeapInitBytes = nonHeapInitBytes;
        this.objectPendingFinalizationCount = objectPendingFinalizationCount;
    }

    public MemoryRecord(Object[] values) {
        super(values, TYPES);
        this.heapMaxBytes = (Long)values[3];
        this.heapUsedBytes = (Long)values[4];
        this.heapCommittedBytes = (Long)values[5];
        this.heapInitBytes = (Long)values[6];
        this.nonHeapMaxBytes = (Long)values[7];
        this.nonHeapUsedBytes = (Long)values[8];
        this.nonHeapCommittedBytes = (Long)values[9];
        this.nonHeapInitBytes = (Long)values[10];
        this.objectPendingFinalizationCount = (Integer)values[11];
    }

    protected MemoryRecord(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.heapMaxBytes = (Long)values[3];
        this.heapUsedBytes = (Long)values[4];
        this.heapCommittedBytes = (Long)values[5];
        this.heapInitBytes = (Long)values[6];
        this.nonHeapMaxBytes = (Long)values[7];
        this.nonHeapUsedBytes = (Long)values[8];
        this.nonHeapCommittedBytes = (Long)values[9];
        this.nonHeapInitBytes = (Long)values[10];
        this.objectPendingFinalizationCount = (Integer)values[11];
    }

    public MemoryRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.heapMaxBytes = buffer.getLong();
        this.heapUsedBytes = buffer.getLong();
        this.heapCommittedBytes = buffer.getLong();
        this.heapInitBytes = buffer.getLong();
        this.nonHeapMaxBytes = buffer.getLong();
        this.nonHeapUsedBytes = buffer.getLong();
        this.nonHeapCommittedBytes = buffer.getLong();
        this.nonHeapInitBytes = buffer.getLong();
        this.objectPendingFinalizationCount = buffer.getInt();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getHostname(), this.getVmName(), this.getHeapMaxBytes(), this.getHeapUsedBytes(), this.getHeapCommittedBytes(), this.getHeapInitBytes(), this.getNonHeapMaxBytes(), this.getNonHeapUsedBytes(), this.getNonHeapCommittedBytes(), this.getNonHeapInitBytes(), this.getObjectPendingFinalizationCount()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(stringRegistry.get(this.getVmName()));
        buffer.putLong(this.getHeapMaxBytes());
        buffer.putLong(this.getHeapUsedBytes());
        buffer.putLong(this.getHeapCommittedBytes());
        buffer.putLong(this.getHeapInitBytes());
        buffer.putLong(this.getNonHeapMaxBytes());
        buffer.putLong(this.getNonHeapUsedBytes());
        buffer.putLong(this.getNonHeapCommittedBytes());
        buffer.putLong(this.getNonHeapInitBytes());
        buffer.putInt(this.getObjectPendingFinalizationCount());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 84;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getHeapMaxBytes() {
        return this.heapMaxBytes;
    }

    public final long getHeapUsedBytes() {
        return this.heapUsedBytes;
    }

    public final long getHeapCommittedBytes() {
        return this.heapCommittedBytes;
    }

    public final long getHeapInitBytes() {
        return this.heapInitBytes;
    }

    public final long getNonHeapMaxBytes() {
        return this.nonHeapMaxBytes;
    }

    public final long getNonHeapUsedBytes() {
        return this.nonHeapUsedBytes;
    }

    public final long getNonHeapCommittedBytes() {
        return this.nonHeapCommittedBytes;
    }

    public final long getNonHeapInitBytes() {
        return this.nonHeapInitBytes;
    }

    public final int getObjectPendingFinalizationCount() {
        return this.objectPendingFinalizationCount;
    }
}

