/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.concurrency;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.flow.trace.AbstractTraceEvent;
import kieker.common.util.registry.IRegistry;

public class JoinEvent
extends AbstractTraceEvent {
    public static final int SIZE = 28;
    private static final long serialVersionUID = 8247379140800787016L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE};
    public static final long JOINED_TRACE_ID = 0L;
    private final long joinedTraceId;

    public JoinEvent(long timestamp, long traceId, int orderIndex, long joinedTraceId) {
        super(timestamp, traceId, orderIndex);
        this.joinedTraceId = joinedTraceId;
    }

    public JoinEvent(Object[] values) {
        super(values, TYPES);
        this.joinedTraceId = (Long)values[3];
    }

    protected JoinEvent(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.joinedTraceId = (Long)values[3];
    }

    public JoinEvent(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.joinedTraceId = buffer.getLong();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getTraceId(), this.getOrderIndex(), this.getJoinedTraceId()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putLong(this.getTraceId());
        buffer.putInt(this.getOrderIndex());
        buffer.putLong(this.getJoinedTraceId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 28;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getJoinedTraceId() {
        return this.joinedTraceId;
    }
}

