/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.misc.RegistryRecord;
import kieker.common.util.registry.ILookup;

class TCPStringReader
extends Thread {
    private static final int MESSAGE_BUFFER_SIZE = 65535;
    private static final Log LOG = LogFactory.getLog(TCPStringReader.class);
    private final int port;
    private final ILookup<String> stringRegistry;
    private volatile boolean terminated = false;
    private volatile Thread readerThread;

    public TCPStringReader(int port, ILookup<String> stringRegistry) {
        this.port = port;
        this.stringRegistry = stringRegistry;
    }

    public void terminate() {
        this.terminated = true;
        this.readerThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.readerThread = Thread.currentThread();
        ServerSocketChannel serversocket = null;
        try {
            serversocket = ServerSocketChannel.open();
            serversocket.socket().bind(new InetSocketAddress(this.port));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Listening on port " + this.port);
            }
            SocketChannel socketChannel = serversocket.accept();
            ByteBuffer buffer = ByteBuffer.allocateDirect(65535);
            while (socketChannel.read(buffer) != -1 && !this.terminated) {
                buffer.flip();
                try {
                    while (buffer.hasRemaining()) {
                        buffer.mark();
                        RegistryRecord.registerRecordInRegistry(buffer, this.stringRegistry);
                    }
                    buffer.clear();
                }
                catch (BufferUnderflowException ex) {
                    buffer.reset();
                    buffer.compact();
                }
            }
            socketChannel.close();
        }
        catch (ClosedByInterruptException ex) {
            LOG.warn("Reader interrupted", ex);
        }
        catch (IOException ex) {
            LOG.error("Error while reading", ex);
        }
        finally {
            block22: {
                if (null != serversocket) {
                    try {
                        serversocket.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block22;
                        LOG.debug("Failed to close TCP connection!", e);
                    }
                }
            }
        }
    }
}

