/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxPerimeter;
import com.mxgraph.view.mxStyleRegistry;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraphView
extends mxEventSource {
    private static mxPoint EMPTY_POINT = new mxPoint();
    protected mxGraph graph;
    protected Object currentRoot = null;
    protected mxRectangle graphBounds = new mxRectangle();
    protected double scale = 1.0;
    protected mxPoint translate = new mxPoint(0.0, 0.0);
    protected Hashtable<Object, mxCellState> states = new Hashtable();

    public mxGraphView(mxGraph mxGraph2) {
        this.graph = mxGraph2;
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public Hashtable<Object, mxCellState> getStates() {
        return this.states;
    }

    public void setStates(Hashtable<Object, mxCellState> hashtable) {
        this.states = hashtable;
    }

    public mxRectangle getGraphBounds() {
        return this.graphBounds;
    }

    public void setGraphBounds(mxRectangle mxRectangle2) {
        this.graphBounds = mxRectangle2;
    }

    public Object getCurrentRoot() {
        return this.currentRoot;
    }

    public Object setCurrentRoot(Object object) {
        if (this.currentRoot != object) {
            mxCurrentRootChange mxCurrentRootChange2 = new mxCurrentRootChange(this, object);
            mxCurrentRootChange2.execute();
            mxUndoableEdit mxUndoableEdit2 = new mxUndoableEdit(this, false);
            mxUndoableEdit2.add(mxCurrentRootChange2);
            this.fireEvent(new mxEventObject("undo", "edit", mxUndoableEdit2));
        }
        return object;
    }

    public void scaleAndTranslate(double d, double d2, double d3) {
        double d4 = this.scale;
        Object object = this.translate.clone();
        if (d != this.scale || d2 != this.translate.getX() || d3 != this.translate.getY()) {
            this.scale = d;
            this.translate = new mxPoint(d2, d3);
            if (this.isEventsEnabled()) {
                this.revalidate();
            }
        }
        this.fireEvent(new mxEventObject("scaleAndTranslate", "scale", d, "previousScale", d4, "translate", this.translate, "previousTranslate", object));
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        double d2 = this.scale;
        if (this.scale != d) {
            this.scale = d;
            if (this.isEventsEnabled()) {
                this.revalidate();
            }
        }
        this.fireEvent(new mxEventObject("scale", "scale", this.scale, "previousScale", d2));
    }

    public mxPoint getTranslate() {
        return this.translate;
    }

    public void setTranslate(mxPoint mxPoint2) {
        Object object = this.translate.clone();
        if (mxPoint2 != null && (mxPoint2.getX() != this.translate.getX() || mxPoint2.getY() != this.translate.getY())) {
            this.translate = mxPoint2;
            if (this.isEventsEnabled()) {
                this.revalidate();
            }
        }
        this.fireEvent(new mxEventObject("translate", "translate", this.translate, "previousTranslate", object));
    }

    public mxRectangle getBounds(Object[] objectArray) {
        return this.getBounds(objectArray, false);
    }

    public mxRectangle getBoundingBox(Object[] objectArray) {
        return this.getBounds(objectArray, true);
    }

    public mxRectangle getBounds(Object[] objectArray, boolean bl) {
        mxRectangle mxRectangle2 = null;
        if (objectArray != null && objectArray.length > 0) {
            mxIGraphModel mxIGraphModel2 = this.graph.getModel();
            for (int i = 0; i < objectArray.length; ++i) {
                mxRectangle mxRectangle3;
                mxCellState mxCellState2;
                if (!mxIGraphModel2.isVertex(objectArray[i]) && !mxIGraphModel2.isEdge(objectArray[i]) || (mxCellState2 = this.getState(objectArray[i])) == null) continue;
                mxRectangle mxRectangle4 = mxRectangle3 = bl ? mxCellState2.getBoundingBox() : mxCellState2;
                if (mxRectangle3 == null) continue;
                if (mxRectangle2 == null) {
                    mxRectangle2 = new mxRectangle(mxRectangle3);
                    continue;
                }
                mxRectangle2.add(mxRectangle3);
            }
        }
        return mxRectangle2;
    }

    public void reload() {
        this.states.clear();
        this.validate();
    }

    public void revalidate() {
        this.invalidate();
        this.validate();
    }

    public void invalidate() {
        this.invalidate(null);
    }

    public void clear(Object object, boolean bl, boolean bl2) {
        this.removeState(object);
        if (bl2 && (bl || object != this.currentRoot)) {
            mxIGraphModel mxIGraphModel2 = this.graph.getModel();
            int n = mxIGraphModel2.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                this.clear(mxIGraphModel2.getChildAt(object, i), bl, bl2);
            }
        } else {
            this.invalidate(object);
        }
    }

    public void invalidate(Object object) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        mxCellState mxCellState2 = this.getState(object = object != null ? object : mxIGraphModel2.getRoot());
        if (mxCellState2 == null || !mxCellState2.isInvalid()) {
            int n;
            if (mxCellState2 != null) {
                mxCellState2.setInvalid(true);
            }
            int n2 = mxIGraphModel2.getChildCount(object);
            for (n = 0; n < n2; ++n) {
                Object object2 = mxIGraphModel2.getChildAt(object, n);
                this.invalidate(object2);
            }
            n = mxIGraphModel2.getEdgeCount(object);
            for (int i = 0; i < n; ++i) {
                this.invalidate(mxIGraphModel2.getEdgeAt(object, i));
            }
        }
    }

    public void validate() {
        Object object;
        Object object2 = object = this.currentRoot != null ? this.currentRoot : this.graph.getModel().getRoot();
        if (object != null) {
            this.validateBounds(null, object);
            mxRectangle mxRectangle2 = this.validatePoints(null, object);
            if (mxRectangle2 == null) {
                mxRectangle2 = new mxRectangle();
            }
            this.setGraphBounds(mxRectangle2);
        }
    }

    public void validateBounds(mxCellState mxCellState2, Object object) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        mxCellState mxCellState3 = this.getState(object, true);
        if (mxCellState3 != null && mxCellState3.isInvalid()) {
            mxPoint mxPoint2;
            if (!this.graph.isCellVisible(object)) {
                this.removeState(object);
            } else if (object != this.currentRoot && mxCellState2 != null) {
                mxCellState3.getAbsoluteOffset().setX(0.0);
                mxCellState3.getAbsoluteOffset().setY(0.0);
                mxCellState3.setOrigin(new mxPoint(mxCellState2.getOrigin()));
                mxPoint2 = this.graph.getCellGeometry(object);
                if (mxPoint2 != null) {
                    if (!mxIGraphModel2.isEdge(object)) {
                        mxPoint mxPoint3 = mxCellState3.getOrigin();
                        mxPoint mxPoint4 = ((mxGeometry)mxPoint2).getOffset();
                        if (mxPoint4 == null) {
                            mxPoint4 = EMPTY_POINT;
                        }
                        if (((mxGeometry)mxPoint2).isRelative()) {
                            mxPoint3.setX(mxPoint3.getX() + mxPoint2.getX() * mxCellState2.getWidth() / this.scale + mxPoint4.getX());
                            mxPoint3.setY(mxPoint3.getY() + mxPoint2.getY() * mxCellState2.getHeight() / this.scale + mxPoint4.getY());
                        } else {
                            mxCellState3.setAbsoluteOffset(new mxPoint(this.scale * mxPoint4.getX(), this.scale * mxPoint4.getY()));
                            mxPoint3.setX(mxPoint3.getX() + mxPoint2.getX());
                            mxPoint3.setY(mxPoint3.getY() + mxPoint2.getY());
                        }
                    }
                    mxCellState3.setX(this.scale * (this.translate.getX() + mxCellState3.getOrigin().getX()));
                    mxCellState3.setY(this.scale * (this.translate.getY() + mxCellState3.getOrigin().getY()));
                    mxCellState3.setWidth(this.scale * ((mxRectangle)mxPoint2).getWidth());
                    mxCellState3.setHeight(this.scale * ((mxRectangle)mxPoint2).getHeight());
                    if (mxIGraphModel2.isVertex(object)) {
                        this.updateVertexLabelOffset(mxCellState3);
                    }
                    this.updateLabel(mxCellState3);
                }
            }
            mxPoint2 = this.graph.getChildOffsetForCell(object);
            if (mxPoint2 != null) {
                mxCellState3.getOrigin().setX(mxCellState3.getOrigin().getX() + mxPoint2.getX());
                mxCellState3.getOrigin().setY(mxCellState3.getOrigin().getY() + mxPoint2.getY());
            }
        }
        if (!(mxCellState3 == null || this.graph.isCellCollapsed(object) && object != this.currentRoot)) {
            int n = mxIGraphModel2.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                this.validateBounds(mxCellState3, mxIGraphModel2.getChildAt(object, i));
            }
        }
    }

    public void updateVertexLabelOffset(mxCellState mxCellState2) {
        String string = mxUtils.getString(mxCellState2.getStyle(), mxConstants.STYLE_LABEL_POSITION, "center");
        if (string.equals("left")) {
            mxCellState2.absoluteOffset.setX(mxCellState2.absoluteOffset.getX() - mxCellState2.getWidth());
        } else if (string.equals("right")) {
            mxCellState2.absoluteOffset.setX(mxCellState2.absoluteOffset.getX() + mxCellState2.getWidth());
        }
        String string2 = mxUtils.getString(mxCellState2.getStyle(), mxConstants.STYLE_VERTICAL_LABEL_POSITION, "middle");
        if (string2.equals("top")) {
            mxCellState2.absoluteOffset.setY(mxCellState2.absoluteOffset.getY() - mxCellState2.getHeight());
        } else if (string2.equals("bottom")) {
            mxCellState2.absoluteOffset.setY(mxCellState2.absoluteOffset.getY() + mxCellState2.getHeight());
        }
    }

    public mxRectangle validatePoints(mxCellState mxCellState2, Object object) {
        mxRectangle mxRectangle2;
        Object object2;
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        mxCellState mxCellState3 = this.getState(object);
        mxRectangle mxRectangle3 = null;
        if (mxCellState3 != null) {
            if (mxCellState3.isInvalid()) {
                mxPoint mxPoint2;
                mxGeometry mxGeometry2 = this.graph.getCellGeometry(object);
                if (mxGeometry2 != null && mxIGraphModel2.isEdge(object)) {
                    mxPoint2 = this.getState(this.getVisibleTerminal(object, true));
                    mxCellState3.setVisibleTerminalState((mxCellState)mxPoint2, true);
                    if (mxPoint2 != null && mxIGraphModel2.isEdge(((mxCellState)mxPoint2).getCell()) && !mxIGraphModel2.isAncestor(mxPoint2, object)) {
                        object2 = this.getState(mxIGraphModel2.getParent(((mxCellState)mxPoint2).getCell()));
                        this.validatePoints((mxCellState)object2, mxPoint2);
                    }
                    object2 = this.getState(this.getVisibleTerminal(object, false));
                    mxCellState3.setVisibleTerminalState((mxCellState)object2, false);
                    if (object2 != null && mxIGraphModel2.isEdge(((mxCellState)object2).getCell()) && !mxIGraphModel2.isAncestor(object2, object)) {
                        mxRectangle2 = this.getState(mxIGraphModel2.getParent(((mxCellState)object2).getCell()));
                        this.validatePoints((mxCellState)mxRectangle2, object2);
                    }
                    this.updateFixedTerminalPoints(mxCellState3, (mxCellState)mxPoint2, (mxCellState)object2);
                    this.updatePoints(mxCellState3, mxGeometry2.getPoints(), (mxCellState)mxPoint2, (mxCellState)object2);
                    this.updateFloatingTerminalPoints(mxCellState3, (mxCellState)mxPoint2, (mxCellState)object2);
                    this.updateEdgeBounds(mxCellState3);
                    mxCellState3.setAbsoluteOffset(this.getPoint(mxCellState3, mxGeometry2));
                } else if (mxGeometry2 != null && mxGeometry2.isRelative() && mxCellState2 != null && mxIGraphModel2.isEdge(mxCellState2.getCell()) && (mxPoint2 = this.getPoint(mxCellState2, mxGeometry2)) != null) {
                    mxCellState3.setX(mxPoint2.getX());
                    mxCellState3.setY(mxPoint2.getY());
                    mxPoint2.setX(mxPoint2.getX() / this.scale - this.translate.getX());
                    mxPoint2.setY(mxPoint2.getY() / this.scale - this.translate.getY());
                    mxCellState3.setOrigin(mxPoint2);
                    this.childMoved(mxCellState2, mxCellState3);
                }
                mxCellState3.setInvalid(false);
            }
            if (mxIGraphModel2.isEdge(object) || mxIGraphModel2.isVertex(object)) {
                this.updateLabelBounds(mxCellState3);
                mxRectangle3 = new mxRectangle(this.updateBoundingBox(mxCellState3));
            }
        }
        if (!(mxCellState3 == null || this.graph.isCellCollapsed(object) && object != this.currentRoot)) {
            int n = mxIGraphModel2.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                object2 = mxIGraphModel2.getChildAt(object, i);
                mxRectangle2 = this.validatePoints(mxCellState3, object2);
                if (mxRectangle2 == null) continue;
                if (mxRectangle3 == null) {
                    mxRectangle3 = mxRectangle2;
                    continue;
                }
                mxRectangle3.add(mxRectangle2);
            }
        }
        return mxRectangle3;
    }

    protected void childMoved(mxCellState mxCellState2, mxCellState mxCellState3) {
        Object object = mxCellState3.getCell();
        if (!this.graph.isCellCollapsed(object) || object == this.currentRoot) {
            mxIGraphModel mxIGraphModel2 = this.graph.getModel();
            int n = mxIGraphModel2.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                this.validateBounds(mxCellState3, mxIGraphModel2.getChildAt(object, i));
            }
        }
    }

    public void updateLabel(mxCellState mxCellState2) {
        String string = this.graph.getLabel(mxCellState2.getCell());
        Map<String, Object> map = mxCellState2.getStyle();
        if (string != null && string.length() > 0 && !this.graph.isHtmlLabel(mxCellState2.getCell()) && !this.graph.getModel().isEdge(mxCellState2.getCell()) && mxUtils.getString(map, mxConstants.STYLE_WHITE_SPACE, "nowrap").equals("wrap")) {
            double d = this.getWordWrapWidth(mxCellState2);
            String[] stringArray = mxUtils.wordWrap(string, mxUtils.getFontMetrics(mxUtils.getFont(mxCellState2.getStyle())), d * mxConstants.LABEL_SCALE_BUFFER);
            if (stringArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string2 : stringArray) {
                    stringBuffer.append(string2 + '\n');
                }
                string = stringBuffer.substring(0, stringBuffer.length() - 1);
            }
        }
        mxCellState2.setLabel(string);
    }

    public double getWordWrapWidth(mxCellState mxCellState2) {
        Map<String, Object> map = mxCellState2.getStyle();
        boolean bl = mxUtils.isTrue(map, mxConstants.STYLE_HORIZONTAL, true);
        double d = 0.0;
        d = bl ? mxCellState2.getWidth() / this.scale - (double)(2 * mxConstants.LABEL_INSET) - 2.0 * mxUtils.getDouble(map, mxConstants.STYLE_SPACING) - mxUtils.getDouble(map, mxConstants.STYLE_SPACING_LEFT) - mxUtils.getDouble(map, mxConstants.STYLE_SPACING_RIGHT) : mxCellState2.getHeight() / this.scale - (double)(2 * mxConstants.LABEL_INSET) - 2.0 * mxUtils.getDouble(map, mxConstants.STYLE_SPACING) - mxUtils.getDouble(map, mxConstants.STYLE_SPACING_TOP) + mxUtils.getDouble(map, mxConstants.STYLE_SPACING_BOTTOM);
        return d;
    }

    public void updateLabelBounds(mxCellState mxCellState2) {
        Object object = mxCellState2.getCell();
        Map<String, Object> map = mxCellState2.getStyle();
        if (mxUtils.getString(map, mxConstants.STYLE_OVERFLOW, "").equals("fill")) {
            mxCellState2.setLabelBounds(new mxRectangle(mxCellState2));
        } else if (mxCellState2.getLabel() != null) {
            mxCellState mxCellState3 = !this.graph.getModel().isEdge(object) ? mxCellState2 : null;
            mxCellState2.setLabelBounds(mxUtils.getLabelPaintBounds(mxCellState2.getLabel(), map, this.graph.isHtmlLabel(object), mxCellState2.getAbsoluteOffset(), mxCellState3, this.scale));
        }
    }

    public mxRectangle updateBoundingBox(mxCellState mxCellState2) {
        mxRectangle mxRectangle2 = new mxRectangle(mxCellState2);
        Map<String, Object> map = mxCellState2.getStyle();
        double d = Math.max(1L, Math.round((double)mxUtils.getInt(map, mxConstants.STYLE_STROKEWIDTH, 1) * this.scale));
        d -= Math.max(1.0, d / 2.0);
        if (this.graph.getModel().isEdge(mxCellState2.getCell())) {
            int n = 0;
            if (map.containsKey(mxConstants.STYLE_ENDARROW) || map.containsKey(mxConstants.STYLE_STARTARROW)) {
                n = (int)Math.round((double)mxConstants.DEFAULT_MARKERSIZE * this.scale);
            }
            mxRectangle2.grow((double)n + d);
            if (mxUtils.getString(map, mxConstants.STYLE_SHAPE, "").equals("arrow")) {
                mxRectangle2.grow(mxConstants.ARROW_WIDTH / 2);
            }
        } else {
            mxRectangle2.grow(d);
        }
        if (mxUtils.isTrue(map, mxConstants.STYLE_SHADOW)) {
            mxRectangle2.setWidth(mxRectangle2.getWidth() + (double)mxConstants.SHADOW_OFFSETX);
            mxRectangle2.setHeight(mxRectangle2.getHeight() + (double)mxConstants.SHADOW_OFFSETY);
        }
        if (mxUtils.getString(map, mxConstants.STYLE_SHAPE, "").equals("label") && mxUtils.getString(map, mxConstants.STYLE_IMAGE) != null) {
            double d2 = (double)mxUtils.getInt(map, mxConstants.STYLE_IMAGE_WIDTH, mxConstants.DEFAULT_IMAGESIZE) * this.scale;
            double d3 = (double)mxUtils.getInt(map, mxConstants.STYLE_IMAGE_HEIGHT, mxConstants.DEFAULT_IMAGESIZE) * this.scale;
            double d4 = mxCellState2.getX();
            double d5 = 0.0;
            String string = mxUtils.getString(map, mxConstants.STYLE_IMAGE_ALIGN, "left");
            String string2 = mxUtils.getString(map, mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, "middle");
            if (string.equals("right")) {
                d4 += mxCellState2.getWidth() - d2;
            } else if (string.equals("center")) {
                d4 += (mxCellState2.getWidth() - d2) / 2.0;
            }
            d5 = string2.equals("top") ? mxCellState2.getY() : (string2.equals("bottom") ? mxCellState2.getY() + mxCellState2.getHeight() - d3 : mxCellState2.getY() + (mxCellState2.getHeight() - d3) / 2.0);
            mxRectangle2.add(new mxRectangle(d4, d5, d2, d3));
        }
        double d6 = mxUtils.getDouble(map, mxConstants.STYLE_ROTATION);
        mxRectangle mxRectangle3 = mxUtils.getBoundingBox(mxRectangle2, d6);
        mxRectangle2.add(mxRectangle3);
        if (!this.graph.isLabelClipped(mxCellState2.getCell())) {
            mxRectangle2.add(mxCellState2.getLabelBounds());
        }
        mxCellState2.setBoundingBox(mxRectangle2);
        return mxRectangle2;
    }

    public void updateFixedTerminalPoints(mxCellState mxCellState2, mxCellState mxCellState3, mxCellState mxCellState4) {
        this.updateFixedTerminalPoint(mxCellState2, mxCellState3, true, this.graph.getConnectionConstraint(mxCellState2, mxCellState3, true));
        this.updateFixedTerminalPoint(mxCellState2, mxCellState4, false, this.graph.getConnectionConstraint(mxCellState2, mxCellState4, false));
    }

    public void updateFixedTerminalPoint(mxCellState mxCellState2, mxCellState mxCellState3, boolean bl, mxConnectionConstraint mxConnectionConstraint2) {
        mxPoint mxPoint2 = null;
        if (mxConnectionConstraint2 != null) {
            mxPoint2 = this.graph.getConnectionPoint(mxCellState3, mxConnectionConstraint2);
        }
        if (mxPoint2 == null && mxCellState3 == null) {
            mxPoint mxPoint3 = mxCellState2.getOrigin();
            mxGeometry mxGeometry2 = this.graph.getCellGeometry(mxCellState2.cell);
            mxPoint2 = mxGeometry2.getTerminalPoint(bl);
            if (mxPoint2 != null) {
                mxPoint2 = new mxPoint(this.scale * (this.translate.getX() + mxPoint2.getX() + mxPoint3.getX()), this.scale * (this.translate.getY() + mxPoint2.getY() + mxPoint3.getY()));
            }
        }
        mxCellState2.setAbsoluteTerminalPoint(mxPoint2, bl);
    }

    public void updatePoints(mxCellState mxCellState2, List<mxPoint> list, mxCellState mxCellState3, mxCellState mxCellState4) {
        if (mxCellState2 != null) {
            ArrayList<mxPoint> arrayList = new ArrayList<mxPoint>();
            arrayList.add(mxCellState2.getAbsolutePoint(0));
            mxEdgeStyle.mxEdgeStyleFunction mxEdgeStyleFunction2 = this.getEdgeStyle(mxCellState2, list, mxCellState3, mxCellState4);
            if (mxEdgeStyleFunction2 != null) {
                mxCellState mxCellState5 = this.getTerminalPort(mxCellState2, mxCellState3, true);
                mxCellState mxCellState6 = this.getTerminalPort(mxCellState2, mxCellState4, false);
                mxEdgeStyleFunction2.apply(mxCellState2, mxCellState5, mxCellState6, list, arrayList);
            } else if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(this.transformControlPoint(mxCellState2, list.get(i)));
                }
            }
            arrayList.add(mxCellState2.getAbsolutePoint(mxCellState2.getAbsolutePointCount() - 1));
            mxCellState2.setAbsolutePoints(arrayList);
        }
    }

    public mxPoint transformControlPoint(mxCellState mxCellState2, mxPoint mxPoint2) {
        mxPoint mxPoint3 = mxCellState2.getOrigin();
        return new mxPoint(this.scale * (mxPoint2.getX() + this.translate.getX() + mxPoint3.getX()), this.scale * (mxPoint2.getY() + this.translate.getY() + mxPoint3.getY()));
    }

    public mxEdgeStyle.mxEdgeStyleFunction getEdgeStyle(mxCellState mxCellState2, List<mxPoint> list, Object object, Object object2) {
        Object object3 = null;
        if (object != null && object == object2) {
            object3 = mxCellState2.getStyle().get(mxConstants.STYLE_LOOP);
            if (object3 == null) {
                object3 = this.graph.getDefaultLoopStyle();
            }
        } else if (!mxUtils.isTrue(mxCellState2.getStyle(), mxConstants.STYLE_NOEDGESTYLE, false)) {
            object3 = mxCellState2.getStyle().get(mxConstants.STYLE_EDGE);
        }
        if (object3 instanceof String) {
            String string = String.valueOf(object3);
            Object object4 = mxStyleRegistry.getValue(string);
            if (object4 == null) {
                object4 = mxUtils.eval(string);
            }
            object3 = object4;
        }
        if (object3 instanceof mxEdgeStyle.mxEdgeStyleFunction) {
            return (mxEdgeStyle.mxEdgeStyleFunction)object3;
        }
        return null;
    }

    public void updateFloatingTerminalPoints(mxCellState mxCellState2, mxCellState mxCellState3, mxCellState mxCellState4) {
        mxPoint mxPoint2 = mxCellState2.getAbsolutePoint(0);
        mxPoint mxPoint3 = mxCellState2.getAbsolutePoint(mxCellState2.getAbsolutePointCount() - 1);
        if (mxPoint3 == null && mxCellState4 != null) {
            this.updateFloatingTerminalPoint(mxCellState2, mxCellState4, mxCellState3, false);
        }
        if (mxPoint2 == null && mxCellState3 != null) {
            this.updateFloatingTerminalPoint(mxCellState2, mxCellState3, mxCellState4, true);
        }
    }

    public void updateFloatingTerminalPoint(mxCellState mxCellState2, mxCellState mxCellState3, mxCellState mxCellState4, boolean bl) {
        mxCellState3 = this.getTerminalPort(mxCellState2, mxCellState3, bl);
        mxPoint mxPoint2 = this.getNextPoint(mxCellState2, mxCellState4, bl);
        double d = mxUtils.getDouble(mxCellState2.getStyle(), mxConstants.STYLE_PERIMETER_SPACING);
        mxPoint mxPoint3 = this.getPerimeterPoint(mxCellState3, mxPoint2, this.graph.isOrthogonal(mxCellState2), d += mxUtils.getDouble(mxCellState2.getStyle(), bl ? mxConstants.STYLE_SOURCE_PERIMETER_SPACING : mxConstants.STYLE_TARGET_PERIMETER_SPACING));
        mxCellState2.setAbsoluteTerminalPoint(mxPoint3, bl);
    }

    public mxCellState getTerminalPort(mxCellState mxCellState2, mxCellState mxCellState3, boolean bl) {
        mxCellState mxCellState4;
        String string = bl ? mxConstants.STYLE_SOURCE_PORT : mxConstants.STYLE_TARGET_PORT;
        String string2 = mxUtils.getString(mxCellState2.style, string);
        if (string2 != null && this.graph.getModel() instanceof mxGraphModel && (mxCellState4 = this.getState(((mxGraphModel)this.graph.getModel()).getCell(string2))) != null) {
            mxCellState3 = mxCellState4;
        }
        return mxCellState3;
    }

    public mxPoint getPerimeterPoint(mxCellState mxCellState2, mxPoint mxPoint2, boolean bl) {
        return this.getPerimeterPoint(mxCellState2, mxPoint2, bl, 0.0);
    }

    public mxPoint getPerimeterPoint(mxCellState mxCellState2, mxPoint mxPoint2, boolean bl, double d) {
        mxPoint mxPoint3 = null;
        if (mxCellState2 != null) {
            mxRectangle mxRectangle2;
            mxPerimeter.mxPerimeterFunction mxPerimeterFunction2 = this.getPerimeterFunction(mxCellState2);
            if (mxPerimeterFunction2 != null && mxPoint2 != null && ((mxRectangle2 = this.getPerimeterBounds(mxCellState2, d)).getWidth() > 0.0 || mxRectangle2.getHeight() > 0.0)) {
                mxPoint3 = mxPerimeterFunction2.apply(mxRectangle2, mxCellState2, mxPoint2, bl);
            }
            if (mxPoint3 == null) {
                mxPoint3 = this.getPoint(mxCellState2);
            }
        }
        return mxPoint3;
    }

    public double getRoutingCenterX(mxCellState mxCellState2) {
        float f = mxCellState2.getStyle() != null ? mxUtils.getFloat(mxCellState2.getStyle(), mxConstants.STYLE_ROUTING_CENTER_X) : 0.0f;
        return mxCellState2.getCenterX() + (double)f * mxCellState2.getWidth();
    }

    public double getRoutingCenterY(mxCellState mxCellState2) {
        float f = mxCellState2.getStyle() != null ? mxUtils.getFloat(mxCellState2.getStyle(), mxConstants.STYLE_ROUTING_CENTER_Y) : 0.0f;
        return mxCellState2.getCenterY() + (double)f * mxCellState2.getHeight();
    }

    public mxRectangle getPerimeterBounds(mxCellState mxCellState2, double d) {
        if (mxCellState2 != null) {
            d += mxUtils.getDouble(mxCellState2.getStyle(), mxConstants.STYLE_PERIMETER_SPACING);
        }
        return mxCellState2.getPerimeterBounds(d * this.scale);
    }

    public mxPerimeter.mxPerimeterFunction getPerimeterFunction(mxCellState mxCellState2) {
        Object object = mxCellState2.getStyle().get(mxConstants.STYLE_PERIMETER);
        if (object instanceof String) {
            String string = String.valueOf(object);
            Object object2 = mxStyleRegistry.getValue(string);
            if (object2 == null) {
                object2 = mxUtils.eval(string);
            }
            object = object2;
        }
        if (object instanceof mxPerimeter.mxPerimeterFunction) {
            return (mxPerimeter.mxPerimeterFunction)object;
        }
        return null;
    }

    public mxPoint getNextPoint(mxCellState mxCellState2, mxCellState mxCellState3, boolean bl) {
        List<mxPoint> list = mxCellState2.getAbsolutePoints();
        mxPoint mxPoint2 = null;
        if (list != null && (bl || list.size() > 2 || mxCellState3 == null)) {
            int n = list.size();
            int n2 = bl ? Math.min(1, n - 1) : Math.max(0, n - 2);
            mxPoint2 = list.get(n2);
        }
        if (mxPoint2 == null && mxCellState3 != null) {
            mxPoint2 = new mxPoint(mxCellState3.getCenterX(), mxCellState3.getCenterY());
        }
        return mxPoint2;
    }

    public Object getVisibleTerminal(Object object, boolean bl) {
        Object object2;
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        Object object3 = object2 = mxIGraphModel2.getTerminal(object, bl);
        while (object2 != null && object2 != this.currentRoot) {
            if (!this.graph.isCellVisible(object3) || this.graph.isCellCollapsed(object2)) {
                object3 = object2;
            }
            object2 = mxIGraphModel2.getParent(object2);
        }
        if (mxIGraphModel2.getParent(object3) == mxIGraphModel2.getRoot()) {
            object3 = null;
        }
        return object3;
    }

    public void updateEdgeBounds(mxCellState mxCellState2) {
        List<mxPoint> list = mxCellState2.getAbsolutePoints();
        if (list != null && list.size() > 0) {
            mxPoint mxPoint2 = list.get(0);
            mxPoint mxPoint3 = list.get(list.size() - 1);
            if (mxPoint2 == null || mxPoint3 == null) {
                if (mxCellState2.getCell() != this.getCurrentRoot()) {
                    this.removeState(mxCellState2.getCell());
                }
            } else {
                double d;
                if (mxPoint2.getX() != mxPoint3.getX() || mxPoint2.getY() != mxPoint3.getY()) {
                    d = mxPoint3.getX() - mxPoint2.getX();
                    double d2 = mxPoint3.getY() - mxPoint2.getY();
                    mxCellState2.setTerminalDistance(Math.sqrt(d * d + d2 * d2));
                } else {
                    mxCellState2.setTerminalDistance(0.0);
                }
                d = 0.0;
                double[] dArray = new double[list.size() - 1];
                mxPoint mxPoint4 = mxPoint2;
                double d3 = mxPoint4.getX();
                double d4 = mxPoint4.getY();
                double d5 = d3;
                double d6 = d4;
                for (int i = 1; i < list.size(); ++i) {
                    double d7;
                    mxPoint mxPoint5 = list.get(i);
                    if (mxPoint5 == null) continue;
                    double d8 = mxPoint4.getX() - mxPoint5.getX();
                    double d9 = mxPoint4.getY() - mxPoint5.getY();
                    dArray[i - 1] = d7 = Math.sqrt(d8 * d8 + d9 * d9);
                    d += d7;
                    mxPoint4 = mxPoint5;
                    d3 = Math.min(mxPoint4.getX(), d3);
                    d4 = Math.min(mxPoint4.getY(), d4);
                    d5 = Math.max(mxPoint4.getX(), d5);
                    d6 = Math.max(mxPoint4.getY(), d6);
                }
                mxCellState2.setLength(d);
                mxCellState2.setSegments(dArray);
                double d10 = 1.0;
                mxCellState2.setX(d3);
                mxCellState2.setY(d4);
                mxCellState2.setWidth(Math.max(d10, d5 - d3));
                mxCellState2.setHeight(Math.max(d10, d6 - d4));
            }
        }
    }

    public mxPoint getPoint(mxCellState mxCellState2) {
        return this.getPoint(mxCellState2, null);
    }

    public mxPoint getPoint(mxCellState mxCellState2, mxGeometry mxGeometry2) {
        mxPoint mxPoint2;
        double d = mxCellState2.getCenterX();
        double d2 = mxCellState2.getCenterY();
        if (mxCellState2.getSegments() != null && (mxGeometry2 == null || mxGeometry2.isRelative())) {
            double d3 = mxGeometry2 != null ? mxGeometry2.getX() / 2.0 : 0.0;
            int n = mxCellState2.getAbsolutePointCount();
            double d4 = (d3 + 0.5) * mxCellState2.getLength();
            double[] dArray = mxCellState2.getSegments();
            double d5 = dArray[0];
            double d6 = 0.0;
            int n2 = 1;
            while (d4 > d6 + d5 && n2 < n - 1) {
                d6 += d5;
                d5 = dArray[n2++];
            }
            double d7 = d5 == 0.0 ? 0.0 : (d4 - d6) / d5;
            mxPoint mxPoint3 = mxCellState2.getAbsolutePoint(n2 - 1);
            mxPoint mxPoint4 = mxCellState2.getAbsolutePoint(n2);
            if (mxPoint3 != null && mxPoint4 != null) {
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                if (mxGeometry2 != null) {
                    d8 = mxGeometry2.getY();
                    mxPoint mxPoint5 = mxGeometry2.getOffset();
                    if (mxPoint5 != null) {
                        d9 = mxPoint5.getX();
                        d10 = mxPoint5.getY();
                    }
                }
                double d11 = mxPoint4.getX() - mxPoint3.getX();
                double d12 = mxPoint4.getY() - mxPoint3.getY();
                double d13 = d5 == 0.0 ? 0.0 : d12 / d5;
                double d14 = d5 == 0.0 ? 0.0 : d11 / d5;
                d = mxPoint3.getX() + d11 * d7 + (d13 * d8 + d9) * this.scale;
                d2 = mxPoint3.getY() + d12 * d7 - (d14 * d8 - d10) * this.scale;
            }
        } else if (mxGeometry2 != null && (mxPoint2 = mxGeometry2.getOffset()) != null) {
            d += mxPoint2.getX();
            d2 += mxPoint2.getY();
        }
        return new mxPoint(d, d2);
    }

    public mxPoint getRelativePoint(mxCellState mxCellState2, double d, double d2) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(mxCellState2.getCell());
        if (mxGeometry2 != null) {
            int n = mxCellState2.getAbsolutePointCount();
            if (mxGeometry2.isRelative() && n > 1) {
                double d3 = mxCellState2.getLength();
                double[] dArray = mxCellState2.getSegments();
                mxPoint mxPoint2 = mxCellState2.getAbsolutePoint(0);
                mxPoint mxPoint3 = mxCellState2.getAbsolutePoint(1);
                Line2D.Double double_ = new Line2D.Double(mxPoint2.getPoint(), mxPoint3.getPoint());
                double d4 = double_.ptSegDistSq(d, d2);
                int n2 = 0;
                double d5 = 0.0;
                double d6 = 0.0;
                for (int i = 2; i < n; ++i) {
                    d5 += dArray[i - 2];
                    mxPoint3 = mxCellState2.getAbsolutePoint(i);
                    double_ = new Line2D.Double(mxPoint2.getPoint(), mxPoint3.getPoint());
                    double d7 = double_.ptSegDistSq(d, d2);
                    if (d7 < d4) {
                        d4 = d7;
                        n2 = i - 1;
                        d6 = d5;
                    }
                    mxPoint2 = mxPoint3;
                }
                double d8 = dArray[n2];
                mxPoint2 = mxCellState2.getAbsolutePoint(n2);
                mxPoint3 = mxCellState2.getAbsolutePoint(n2 + 1);
                double d9 = mxPoint2.getX();
                double d10 = mxPoint2.getY();
                double d11 = mxPoint3.getX();
                double d12 = mxPoint3.getY();
                double d13 = d;
                double d14 = d2;
                double d15 = d9 - d11;
                double d16 = d10 - d12;
                d13 -= d11;
                d14 -= d12;
                double d17 = 0.0;
                double d18 = (d13 = d15 - d13) * d15 + (d14 = d16 - d14) * d16;
                d17 = d18 <= 0.0 ? 0.0 : d18 * d18 / (d15 * d15 + d16 * d16);
                double d19 = Math.sqrt(d17);
                if (d19 > d8) {
                    d19 = d8;
                }
                double d20 = Line2D.ptLineDist(mxPoint2.getX(), mxPoint2.getY(), mxPoint3.getX(), mxPoint3.getY(), d, d2);
                int n3 = Line2D.relativeCCW(mxPoint2.getX(), mxPoint2.getY(), mxPoint3.getX(), mxPoint3.getY(), d, d2);
                if (n3 == -1) {
                    d20 = -d20;
                }
                return new mxPoint(Math.round((d3 / 2.0 - d6 - d19) / d3 * -2.0), Math.round(d20 / this.scale));
            }
        }
        return new mxPoint();
    }

    public mxCellState[] getCellStates(Object[] objectArray) {
        ArrayList<mxCellState> arrayList = new ArrayList<mxCellState>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            mxCellState mxCellState2 = this.getState(objectArray[i]);
            if (mxCellState2 == null) continue;
            arrayList.add(mxCellState2);
        }
        mxCellState[] mxCellStateArray = new mxCellState[arrayList.size()];
        return arrayList.toArray(mxCellStateArray);
    }

    public mxCellState getState(Object object) {
        return this.getState(object, false);
    }

    public mxCellState getState(Object object, boolean bl) {
        mxCellState mxCellState2 = null;
        if (object != null && (mxCellState2 = this.states.get(object)) == null && bl && this.graph.isCellVisible(object)) {
            mxCellState2 = this.createState(object);
            this.states.put(object, mxCellState2);
        }
        return mxCellState2;
    }

    public mxCellState removeState(Object object) {
        return object != null ? this.states.remove(object) : null;
    }

    public mxCellState createState(Object object) {
        return new mxCellState(this, object, this.graph.getCellStyle(object));
    }

    public static class mxCurrentRootChange
    implements mxUndoableEdit.mxUndoableChange {
        protected mxGraphView view;
        protected Object root;
        protected Object previous;
        protected boolean up;

        public mxCurrentRootChange(mxGraphView mxGraphView2, Object object) {
            this.view = mxGraphView2;
            this.previous = this.root = object;
            boolean bl = this.up = object == null;
            if (!this.up) {
                Object object2 = mxGraphView2.getCurrentRoot();
                mxIGraphModel mxIGraphModel2 = mxGraphView2.graph.getModel();
                while (object2 != null) {
                    if (object2 == object) {
                        this.up = true;
                        break;
                    }
                    object2 = mxIGraphModel2.getParent(object2);
                }
            }
        }

        public mxGraphView getView() {
            return this.view;
        }

        public Object getRoot() {
            return this.root;
        }

        public Object getPrevious() {
            return this.previous;
        }

        public boolean isUp() {
            return this.up;
        }

        public void execute() {
            Object object = this.view.getCurrentRoot();
            this.view.currentRoot = this.previous;
            this.previous = object;
            mxPoint mxPoint2 = this.view.graph.getTranslateForRoot(this.view.getCurrentRoot());
            if (mxPoint2 != null) {
                this.view.translate = new mxPoint(-mxPoint2.getX(), mxPoint2.getY());
            }
            this.view.reload();
            this.up = !this.up;
            String string = this.up ? "up" : "down";
            this.view.fireEvent(new mxEventObject(string, "root", this.view.currentRoot, "previous", this.previous));
        }
    }
}

