/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.bridge.connector.tcp;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.tools.bridge.LookupEntity;
import kieker.tools.bridge.connector.AbstractConnector;
import kieker.tools.bridge.connector.ConnectorDataTransmissionException;
import kieker.tools.bridge.connector.ConnectorEndOfDataException;
import kieker.tools.bridge.connector.ConnectorProperty;
import kieker.tools.bridge.connector.tcp.TCPMultiServerConnectionRunnable;
import kieker.tools.bridge.connector.tcp.TCPMultiServerPortListenerRunnable;

@ConnectorProperty(cmdName="tcp-server", name="TCP Multi Server Connector", description="TCP server for binary Kieker records. Accepts multiple connections.")
public class TCPMultiServerConnector
extends AbstractConnector {
    public static final String PORT = TCPMultiServerConnector.class.getCanonicalName() + ".port";
    private static final int QUEUE_CAPACITY = 10;
    private static final int NUMBER_OF_THREADS = 10;
    private static final long SHUTDOWN_TIMEOUT = 5L;
    private final int port;
    private volatile BlockingQueue<IMonitoringRecord> recordQueue;
    private ExecutorService executor;

    public TCPMultiServerConnector(Configuration configuration, ConcurrentMap<Integer, LookupEntity> lookupEntityMap) {
        super(configuration, lookupEntityMap);
        this.port = this.configuration.getIntProperty(PORT);
    }

    @Override
    public void initialize() throws ConnectorDataTransmissionException {
        this.recordQueue = new ArrayBlockingQueue<IMonitoringRecord>(10);
        this.executor = Executors.newFixedThreadPool(10);
        try {
            this.executor.execute(new TCPMultiServerPortListenerRunnable(this.port, this.recordQueue, this.lookupEntityMap, this.executor));
        }
        catch (IOException e) {
            throw new ConnectorDataTransmissionException("Failed to open server socket", e);
        }
    }

    @Override
    public void close() throws ConnectorDataTransmissionException {
        for (Runnable runnable : this.executor.shutdownNow()) {
            if (runnable instanceof TCPMultiServerPortListenerRunnable) {
                ((TCPMultiServerPortListenerRunnable)runnable).setActive(false);
                continue;
            }
            if (!(runnable instanceof TCPMultiServerConnectionRunnable)) continue;
            ((TCPMultiServerConnectionRunnable)runnable).setActive(false);
        }
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ConnectorDataTransmissionException("Server shutdown failed.", e);
        }
        if (!this.recordQueue.isEmpty()) {
            try {
                for (int retries = 0; retries < 5 && !this.recordQueue.isEmpty(); ++retries) {
                    this.wait(5L);
                }
            }
            catch (InterruptedException e) {
                throw new ConnectorDataTransmissionException("Interrupted while waitig for queue cleanup.", e);
            }
            if (!this.recordQueue.isEmpty()) {
                throw new ConnectorDataTransmissionException("Failed to store all received records.");
            }
        }
    }

    @Override
    public IMonitoringRecord deserializeNextRecord() throws ConnectorDataTransmissionException, ConnectorEndOfDataException {
        try {
            return this.recordQueue.take();
        }
        catch (InterruptedException e) {
            if (this.recordQueue.isEmpty()) {
                throw new ConnectorEndOfDataException("End of all streams reached", e);
            }
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
    }
}

