/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer;

import java.util.Set;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.IMonitoringWriter;

public abstract class AbstractMonitoringWriter
implements IMonitoringWriter {
    protected IMonitoringController monitoringController;
    private final Configuration configuration;

    protected AbstractMonitoringWriter(Configuration configuration) {
        Configuration defaultConfiguration = this.getDefaultConfiguration();
        if (defaultConfiguration != null) {
            configuration.setDefaultConfiguration(defaultConfiguration);
        }
        this.configuration = configuration;
    }

    protected Configuration getDefaultConfiguration() {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Writer: '");
        sb.append(this.getClass().getName());
        sb.append("'\n\tConfiguration:");
        Set<String> keys = this.configuration.stringPropertyNames();
        if (keys.isEmpty()) {
            sb.append("\n\t\tNo Configuration");
        } else {
            for (String property : keys) {
                sb.append("\n\t\t");
                sb.append(property);
                sb.append("='");
                sb.append(this.configuration.getStringProperty(property));
                sb.append('\'');
            }
        }
        return sb.toString();
    }

    @Override
    public final void setController(IMonitoringController controller) throws Exception {
        this.monitoringController = controller;
        this.init();
    }

    protected abstract void init() throws Exception;

    @Override
    public boolean newMonitoringRecordNonBlocking(IMonitoringRecord record) {
        return this.newMonitoringRecord(record);
    }
}

