/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.filesystem;

public final class FSUtil {
    public static final String FILE_PREFIX = "kieker";
    public static final String MAP_FILENAME = "kieker.map";
    public static final String LEGACY_FILE_PREFIX = "tpmon";
    public static final String LEGACY_MAP_FILENAME = "tpmon.map";
    public static final String NORMAL_FILE_EXTENSION = ".dat";
    public static final String ZIP_FILE_EXTENSION = ".zip";
    public static final String ENCODING = "UTF-8";

    private FSUtil() {
    }

    public static final String encodeNewline(String str) {
        int length = str.length();
        StringBuilder sb = new StringBuilder(length + 16);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                changed = true;
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '\r') {
                changed = true;
                sb.append('\\');
                sb.append('r');
                continue;
            }
            if (c == '\n') {
                changed = true;
                sb.append('\\');
                sb.append('n');
                continue;
            }
            sb.append(c);
        }
        if (changed) {
            return sb.toString();
        }
        return str;
    }

    public static final String decodeNewline(String str) {
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                char d;
                if ((d = str.charAt(++i)) == '\\') {
                    changed = true;
                    sb.append('\\');
                    continue;
                }
                if (d == 'r') {
                    changed = true;
                    sb.append('\r');
                    continue;
                }
                if (d == 'n') {
                    changed = true;
                    sb.append('\n');
                    continue;
                }
                sb.append(c);
                sb.append(d);
                continue;
            }
            sb.append(c);
        }
        if (changed) {
            return sb.toString();
        }
        return str;
    }
}

