/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.misc;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class KiekerMetadataRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 37;
    private static final long serialVersionUID = 7506050189318057340L;
    public static final Class<?>[] TYPES = new Class[]{String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, String.class, Long.TYPE};
    public static final String NO_CONTROLLERNAME = "<no-controller-name>";
    public static final String NO_HOSTNAME = "<no-hostname>";
    public static final String NO_TIMESOURCE = "<no-timesource>";
    public static final String NO_TIMEUNIT = "NANOSECONDS";
    public static final String VERSION = "1.10";
    public static final String CONTROLLER_NAME = "<no-controller-name>";
    public static final String HOSTNAME = "<no-hostname>";
    public static final int EXPERIMENT_ID = 0;
    public static final boolean DEBUG_MODE = false;
    public static final long TIME_OFFSET = 0L;
    public static final String TIME_UNIT = "NANOSECONDS";
    public static final long NUMBER_OF_RECORDS = 0L;
    private final String version;
    private final String controllerName;
    private final String hostname;
    private final int experimentId;
    private final boolean debugMode;
    private final long timeOffset;
    private final String timeUnit;
    private final long numberOfRecords;

    public KiekerMetadataRecord(String version, String controllerName, String hostname, int experimentId, boolean debugMode, long timeOffset, String timeUnit, long numberOfRecords) {
        this.version = version == null ? VERSION : version;
        this.controllerName = controllerName == null ? "<no-controller-name>" : controllerName;
        this.hostname = hostname == null ? "<no-hostname>" : hostname;
        this.experimentId = experimentId;
        this.debugMode = debugMode;
        this.timeOffset = timeOffset;
        this.timeUnit = timeUnit == null ? "NANOSECONDS" : timeUnit;
        this.numberOfRecords = numberOfRecords;
    }

    public KiekerMetadataRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.version = (String)values[0];
        this.controllerName = (String)values[1];
        this.hostname = (String)values[2];
        this.experimentId = (Integer)values[3];
        this.debugMode = (Boolean)values[4];
        this.timeOffset = (Long)values[5];
        this.timeUnit = (String)values[6];
        this.numberOfRecords = (Long)values[7];
    }

    protected KiekerMetadataRecord(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.version = (String)values[0];
        this.controllerName = (String)values[1];
        this.hostname = (String)values[2];
        this.experimentId = (Integer)values[3];
        this.debugMode = (Boolean)values[4];
        this.timeOffset = (Long)values[5];
        this.timeUnit = (String)values[6];
        this.numberOfRecords = (Long)values[7];
    }

    public KiekerMetadataRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.version = stringRegistry.get(buffer.getInt());
        this.controllerName = stringRegistry.get(buffer.getInt());
        this.hostname = stringRegistry.get(buffer.getInt());
        this.experimentId = buffer.getInt();
        this.debugMode = buffer.get() == 1;
        this.timeOffset = buffer.getLong();
        this.timeUnit = stringRegistry.get(buffer.getInt());
        this.numberOfRecords = buffer.getLong();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getVersion(), this.getControllerName(), this.getHostname(), this.getExperimentId(), this.isDebugMode(), this.getTimeOffset(), this.getTimeUnit(), this.getNumberOfRecords()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putInt(stringRegistry.get(this.getVersion()));
        buffer.putInt(stringRegistry.get(this.getControllerName()));
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(this.getExperimentId());
        buffer.put((byte)(this.isDebugMode() ? 1 : 0));
        buffer.putLong(this.getTimeOffset());
        buffer.putInt(stringRegistry.get(this.getTimeUnit()));
        buffer.putLong(this.getNumberOfRecords());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 37;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getControllerName() {
        return this.controllerName;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final int getExperimentId() {
        return this.experimentId;
    }

    public final boolean isDebugMode() {
        return this.debugMode;
    }

    public final long getTimeOffset() {
        return this.timeOffset;
    }

    public final String getTimeUnit() {
        return this.timeUnit;
    }

    public final long getNumberOfRecords() {
        return this.numberOfRecords;
    }
}

