/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.controlflow;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class OperationExecutionRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 44;
    private static final long serialVersionUID = -4883357436134811919L;
    public static final Class<?>[] TYPES = new Class[]{String.class, String.class, Long.TYPE, Long.TYPE, Long.TYPE, String.class, Integer.TYPE, Integer.TYPE};
    public static final String NO_HOSTNAME = "<default-host>";
    public static final String NO_SESSION_ID = "<no-session-id>";
    public static final String NO_OPERATION_SIGNATURE = "noOperation";
    public static final long NO_TRACE_ID = -1L;
    public static final long NO_TIMESTAMP = -1L;
    public static final int NO_EOI_ESS = -1;
    public static final String OPERATION_SIGNATURE = "noOperation";
    public static final String SESSION_ID = "<no-session-id>";
    public static final long TRACE_ID = -1L;
    public static final long TIN = -1L;
    public static final long TOUT = -1L;
    public static final String HOSTNAME = "<default-host>";
    public static final int EOI = -1;
    public static final int ESS = -1;
    private final String operationSignature;
    private final String sessionId;
    private final long traceId;
    private final long tin;
    private final long tout;
    private final String hostname;
    private final int eoi;
    private final int ess;

    public OperationExecutionRecord(String operationSignature, String sessionId, long traceId, long tin, long tout, String hostname, int eoi, int ess) {
        this.operationSignature = operationSignature == null ? "noOperation" : operationSignature;
        this.sessionId = sessionId == null ? "<no-session-id>" : sessionId;
        this.traceId = traceId;
        this.tin = tin;
        this.tout = tout;
        this.hostname = hostname == null ? "<default-host>" : hostname;
        this.eoi = eoi;
        this.ess = ess;
    }

    public OperationExecutionRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.operationSignature = (String)values[0];
        this.sessionId = (String)values[1];
        this.traceId = (Long)values[2];
        this.tin = (Long)values[3];
        this.tout = (Long)values[4];
        this.hostname = (String)values[5];
        this.eoi = (Integer)values[6];
        this.ess = (Integer)values[7];
    }

    protected OperationExecutionRecord(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.operationSignature = (String)values[0];
        this.sessionId = (String)values[1];
        this.traceId = (Long)values[2];
        this.tin = (Long)values[3];
        this.tout = (Long)values[4];
        this.hostname = (String)values[5];
        this.eoi = (Integer)values[6];
        this.ess = (Integer)values[7];
    }

    public OperationExecutionRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.operationSignature = stringRegistry.get(buffer.getInt());
        this.sessionId = stringRegistry.get(buffer.getInt());
        this.traceId = buffer.getLong();
        this.tin = buffer.getLong();
        this.tout = buffer.getLong();
        this.hostname = stringRegistry.get(buffer.getInt());
        this.eoi = buffer.getInt();
        this.ess = buffer.getInt();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getOperationSignature(), this.getSessionId(), this.getTraceId(), this.getTin(), this.getTout(), this.getHostname(), this.getEoi(), this.getEss()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putInt(stringRegistry.get(this.getOperationSignature()));
        buffer.putInt(stringRegistry.get(this.getSessionId()));
        buffer.putLong(this.getTraceId());
        buffer.putLong(this.getTin());
        buffer.putLong(this.getTout());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(this.getEoi());
        buffer.putInt(this.getEss());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 44;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final String getOperationSignature() {
        return this.operationSignature;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final long getTraceId() {
        return this.traceId;
    }

    public final long getTin() {
        return this.tin;
    }

    public final long getTout() {
        return this.tout;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final int getEoi() {
        return this.eoi;
    }

    public final int getEss() {
        return this.ess;
    }
}

