/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.File;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.math.R.Logger;
import org.math.R.RserverConf;
import org.math.R.StartRserve;
import org.rosuda.REngine.Rserve.RConnection;

public class Rdaemon {
    RserverConf conf;
    Process process;
    Logger log;
    static File APP_DIR = new File(System.getProperty("user.home") + File.separator + ".Rserve");
    static String R_HOME = null;
    static final String R_HOME_KEY = "R_HOME";
    static final String Rserve_HOME_KEY = "Rserve_HOME";

    public Rdaemon(RserverConf conf, Logger log, String R_HOME, String Rserve_HOME) {
        this.conf = conf;
        this.log = log;
        Rdaemon.findR_HOME(R_HOME);
        this.println("Environment variables:\n  R_HOME=" + Rdaemon.R_HOME);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Rdaemon.this._stop();
            }
        });
    }

    private void _stop() {
        this.stop();
    }

    public Rdaemon(RserverConf conf, Logger log) {
        this(conf, log, null, null);
    }

    public static boolean findR_HOME(String r_HOME) {
        Map<String, String> env = System.getenv();
        Properties prop = System.getProperties();
        R_HOME = r_HOME;
        if (R_HOME == null || !new File(R_HOME).exists()) {
            if (env.containsKey(R_HOME_KEY)) {
                R_HOME = env.get(R_HOME_KEY);
            }
            if (R_HOME == null || prop.containsKey(R_HOME_KEY) || !new File(R_HOME).exists()) {
                R_HOME = prop.getProperty(R_HOME_KEY);
            }
            if (R_HOME == null || !new File(R_HOME).exists()) {
                R_HOME = null;
                if (System.getProperty("os.name").contains("Win")) {
                    block0: for (int major = 10; major >= 0 && R_HOME == null; --major) {
                        for (int minor = 5; minor >= 0; --minor) {
                            r_HOME = "C:\\Program Files\\R\\R-2." + major + "." + minor + "\\";
                            if (!new File(r_HOME).exists()) continue;
                            R_HOME = r_HOME;
                            continue block0;
                        }
                    }
                } else {
                    R_HOME = "/usr/lib/R/";
                }
            }
        }
        if (R_HOME == null) {
            return false;
        }
        return new File(R_HOME).exists();
    }

    static void setRecursiveExecutable(File path) {
        for (File f : path.listFiles()) {
            if (f.isDirectory()) {
                f.setExecutable(true);
                Rdaemon.setRecursiveExecutable(f);
                continue;
            }
            if (f.canExecute() || !f.getName().endsWith(".so") && !f.getName().endsWith(".dll")) continue;
            f.setExecutable(true);
        }
    }

    public void println(String m) {
        this.log.println(m);
    }

    public void stop() {
        this.println("stopping R daemon... " + this.conf);
        if (!this.conf.isLocal()) {
            throw new UnsupportedOperationException("Not authorized to stop a remote R daemon: " + this.conf.toString());
        }
        try {
            RConnection s = this.conf.connect();
            if (s == null || !s.isConnected()) {
                this.println("R daemon already stoped.");
                return;
            }
            s.shutdown();
        }
        catch (Exception ex) {
            this.println(ex.getMessage());
        }
        this.println("R daemon stoped.");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void start(String http_proxy) {
        boolean started;
        if (R_HOME == null) throw new IllegalArgumentException("R_HOME environment variable not correctly set.\nYou can set it using 'java ... -DR_HOME=[Path to R] ...' startup command.");
        if (!new File(R_HOME).exists()) {
            throw new IllegalArgumentException("R_HOME environment variable not correctly set.\nYou can set it using 'java ... -DR_HOME=[Path to R] ...' startup command.");
        }
        if (!this.conf.isLocal()) {
            throw new UnsupportedOperationException("Unable to start a remote R daemon: " + this.conf.toString());
        }
        this.println("checking Rserve is available... ");
        boolean RserveInstalled = StartRserve.isRserveInstalled(R_HOME + File.separator + "bin" + File.separator + "R" + (System.getProperty("os.name").contains("Win") ? ".exe" : ""));
        if (!RserveInstalled) {
            this.println("  no");
            RserveInstalled = StartRserve.installRserve(R_HOME + File.separator + "bin" + File.separator + "R" + (System.getProperty("os.name").contains("Win") ? ".exe" : ""), http_proxy);
            if (!RserveInstalled) {
                this.println("  failed.");
                String notice = "Please install Rserve manually in your R environment using \"install.packages('Rserve',,'http://www.rforge.net/')\" command.";
                this.println(notice);
                System.err.println(notice);
                return;
            }
            this.println("  ok");
        } else {
            this.println("  ok");
        }
        this.println("starting R daemon... " + this.conf);
        StringBuffer RserveArgs = new StringBuffer("--no-save --slave");
        if (this.conf.port > 0) {
            RserveArgs.append(" --RS-port " + this.conf.port);
        }
        if (started = StartRserve.launchRserve(R_HOME + File.separator + "bin" + File.separator + "R" + (System.getProperty("os.name").contains("Win") ? ".exe" : ""), "--no-save --slave", RserveArgs.toString(), false)) {
            this.println("  ok");
            return;
        }
        this.println("  failed");
    }

    public static String timeDigest() {
        long time = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        StringBuffer sb = new StringBuffer();
        sb = sdf.format(new Date(time), sb, new FieldPosition(0));
        return sb.toString();
    }

    public static void main(String[] args) throws InterruptedException {
        Rdaemon d = new Rdaemon(new RserverConf(null, -1, null, null, null), new Logger(){

            @Override
            public void println(String message) {
                System.err.println(message);
            }
        });
        d.start(null);
        Thread.sleep(2000L);
        d.stop();
        Thread.sleep(2000L);
    }

    static {
        boolean app_dir_ok = false;
        if (!APP_DIR.exists()) {
            app_dir_ok = APP_DIR.mkdir();
        } else {
            boolean bl = app_dir_ok = APP_DIR.isDirectory() && APP_DIR.canWrite();
        }
        if (!app_dir_ok) {
            System.err.println("Cannot write in " + APP_DIR.getAbsolutePath());
        }
    }
}

