/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib.forecast;

import kieker.tools.tslib.ITimeSeries;
import kieker.tools.tslib.TimeSeries;
import kieker.tools.tslib.forecast.IForecaster;

public abstract class AbstractForecaster<T>
implements IForecaster<T> {
    private final ITimeSeries<T> historyTimeseries;
    private final int confidenceLevel;

    public AbstractForecaster(ITimeSeries<T> historyTimeseries) {
        this(historyTimeseries, 0);
    }

    public AbstractForecaster(ITimeSeries<T> historyTimeseries, int confidenceLevel) {
        this.historyTimeseries = historyTimeseries;
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public ITimeSeries<T> getTsOriginal() {
        return this.historyTimeseries;
    }

    protected ITimeSeries<T> prepareForecastTS() {
        ITimeSeries<T> history = this.getTsOriginal();
        long startTime = history.getStartTime();
        TimeSeries tsFC = new TimeSeries(startTime, history.getTimeSeriesTimeUnit(), history.getDeltaTime(), history.getDeltaTimeUnit());
        return tsFC;
    }

    @Override
    public int getConfidenceLevel() {
        return this.confidenceLevel;
    }
}

