/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib;

import org.apache.commons.math3.stat.StatUtils;

public enum AggregationMethod {
    GEOMETRIC_MEAN,
    MAX,
    MEAN,
    MIN,
    PERCENTILE90,
    PERCENTILE95,
    PRODUCT,
    SUM,
    SUMLOG,
    SUMSQ,
    VARIANCE;


    public double getAggregationValue(double[] aggregationValues) {
        switch (this) {
            case GEOMETRIC_MEAN: {
                return StatUtils.geometricMean((double[])aggregationValues);
            }
            case MAX: {
                return StatUtils.max((double[])aggregationValues);
            }
            case MEAN: {
                return StatUtils.mean((double[])aggregationValues);
            }
            case MIN: {
                return StatUtils.min((double[])aggregationValues);
            }
            case PERCENTILE90: {
                return StatUtils.percentile((double[])aggregationValues, (double)90.0);
            }
            case PERCENTILE95: {
                return StatUtils.percentile((double[])aggregationValues, (double)95.0);
            }
            case PRODUCT: {
                return StatUtils.product((double[])aggregationValues);
            }
            case SUM: {
                return StatUtils.sum((double[])aggregationValues);
            }
            case SUMSQ: {
                return StatUtils.sumSq((double[])aggregationValues);
            }
            case SUMLOG: {
                return StatUtils.sumLog((double[])aggregationValues);
            }
            case VARIANCE: {
                return StatUtils.variance((double[])aggregationValues);
            }
        }
        return StatUtils.mean((double[])aggregationValues);
    }
}

