/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.bridge.connector.jms;

import java.util.concurrent.ConcurrentMap;
import kieker.common.configuration.Configuration;
import kieker.tools.bridge.LookupEntity;
import kieker.tools.bridge.connector.ConnectorDataTransmissionException;
import kieker.tools.bridge.connector.ConnectorProperty;
import kieker.tools.bridge.connector.jms.JMSClientConnector;
import org.apache.activemq.broker.BrokerService;

@ConnectorProperty(cmdName="jms-embedded", name="JMS Embedded Connector", description="JMS Client to receive records from a built-in JMS queue.")
public class JMSEmbeddedConnector
extends JMSClientConnector {
    public static final String PORT = JMSEmbeddedConnector.class.getCanonicalName() + ".port";
    private BrokerService broker;
    private final int port;

    public JMSEmbeddedConnector(Configuration configuration, ConcurrentMap<Integer, LookupEntity> lookupEntityMap) {
        super(configuration, lookupEntityMap);
        this.port = this.configuration.getIntProperty(PORT);
        this.configuration.setProperty(JMSClientConnector.class.getCanonicalName() + ".uri", "tcp://localhost:" + this.port);
    }

    @Override
    public void initialize() throws ConnectorDataTransmissionException {
        this.broker = new BrokerService();
        this.broker.setUseJmx(true);
        try {
            this.broker.addConnector("tcp://localhost:" + this.port);
            this.broker.start();
            super.initialize();
        }
        catch (Exception e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws ConnectorDataTransmissionException {
        try {
            super.close();
            this.broker.stop();
        }
        catch (Exception e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
    }
}

