/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.sampler.sigar.samplers;

import kieker.common.record.system.MemSwapUsageRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.signaturePattern.SignatureFactory;
import kieker.monitoring.sampler.sigar.samplers.AbstractSigarSampler;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.Swap;

public class MemSwapUsageSampler
extends AbstractSigarSampler {
    public MemSwapUsageSampler(SigarProxy sigar) {
        super(sigar);
    }

    @Override
    public void sample(IMonitoringController monitoringCtr) throws SigarException {
        if (!monitoringCtr.isMonitoringEnabled()) {
            return;
        }
        if (!monitoringCtr.isProbeActivated(SignatureFactory.createMemSwapSignature())) {
            return;
        }
        Mem mem = this.sigar.getMem();
        Swap swap = this.sigar.getSwap();
        MemSwapUsageRecord r = new MemSwapUsageRecord(monitoringCtr.getTimeSource().getTime(), monitoringCtr.getHostname(), mem.getTotal(), mem.getActualUsed(), mem.getActualFree(), swap.getTotal(), swap.getUsed(), swap.getFree());
        monitoringCtr.newMonitoringRecord(r);
    }
}

