/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj;

import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.monitoring.probe.IMonitoringProbe;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public abstract class AbstractAspectJProbe
implements IMonitoringProbe {
    private final ConcurrentMap<Signature, String> signatureCache = new ConcurrentHashMap<Signature, String>();

    @Pointcut(value="!within(kieker.common..*) && !within(kieker.monitoring..*) && !within(kieker.analysis..*) && !within(kieker.tools..*)")
    public /* synthetic */ void notWithinKieker() {
    }

    @Pointcut(value="execution(void set*(..)) || call(void set*(..))")
    public /* synthetic */ void setter() {
    }

    @Pointcut(value="execution(* get*(..)) || call(* get*(..)) || execution(boolean is*(..)) || call(boolean is*(..))")
    public /* synthetic */ void getter() {
    }

    @Pointcut(value="!getter() && !setter()")
    public /* synthetic */ void noGetterAndSetter() {
    }

    protected String signatureToLongString(Signature sig) {
        String signatureString = (String)this.signatureCache.get(sig);
        if (signatureString != null) {
            return signatureString;
        }
        if (sig instanceof MethodSignature) {
            MethodSignature signature = (MethodSignature)sig;
            StringBuilder sb = new StringBuilder(256);
            String modString = Modifier.toString(signature.getModifiers());
            sb.append(modString);
            if (modString.length() > 0) {
                sb.append(' ');
            }
            this.addType(sb, signature.getReturnType());
            sb.append(' ');
            sb.append(signature.getDeclaringTypeName());
            sb.append('.');
            sb.append(signature.getName());
            sb.append('(');
            this.addTypeList(sb, signature.getParameterTypes());
            sb.append(')');
            signatureString = sb.toString();
        } else if (sig instanceof ConstructorSignature) {
            ConstructorSignature signature = (ConstructorSignature)sig;
            StringBuilder sb = new StringBuilder(256);
            String modString = Modifier.toString(signature.getModifiers());
            sb.append(modString);
            if (modString.length() > 0) {
                sb.append(' ');
            }
            sb.append(signature.getDeclaringTypeName());
            sb.append('.');
            sb.append(signature.getName());
            sb.append('(');
            this.addTypeList(sb, signature.getParameterTypes());
            sb.append(')');
            signatureString = sb.toString();
        } else {
            signatureString = sig.toLongString();
        }
        this.signatureCache.putIfAbsent(sig, signatureString);
        return signatureString;
    }

    private final StringBuilder addTypeList(StringBuilder sb, Class<?>[] clazzes) {
        if (clazzes != null) {
            boolean first = true;
            Class<?>[] classArray = clazzes;
            int n = clazzes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                this.addType(sb, clazz);
                ++n2;
            }
        }
        return sb;
    }

    private final StringBuilder addType(StringBuilder sb, Class<?> clazz) {
        if (clazz == null) {
            sb.append("ANONYMOUS");
        } else if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            this.addType(sb, componentType);
            sb.append("[]");
        } else {
            sb.append(clazz.getName());
        }
        return sb;
    }
}

