/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.system;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class CPUUtilizationRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 72;
    private static final long serialVersionUID = 1353686422654272736L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE};
    public static final long TIMESTAMP = 0L;
    public static final String HOSTNAME = "";
    public static final String CPU_ID = "";
    public static final double USER = 0.0;
    public static final double SYSTEM = 0.0;
    public static final double WAIT = 0.0;
    public static final double NICE = 0.0;
    public static final double IRQ = 0.0;
    public static final double TOTAL_UTILIZATION = 0.0;
    public static final double IDLE = 0.0;
    private final long timestamp;
    private final String hostname;
    private final String cpuID;
    private final double user;
    private final double system;
    private final double wait;
    private final double nice;
    private final double irq;
    private final double totalUtilization;
    private final double idle;

    public CPUUtilizationRecord(long timestamp, String hostname, String cpuID, double user, double system, double wait, double nice, double irq, double totalUtilization, double idle) {
        this.timestamp = timestamp;
        this.hostname = hostname == null ? "" : hostname;
        this.cpuID = cpuID == null ? "" : cpuID;
        this.user = user;
        this.system = system;
        this.wait = wait;
        this.nice = nice;
        this.irq = irq;
        this.totalUtilization = totalUtilization;
        this.idle = idle;
    }

    public CPUUtilizationRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.cpuID = (String)values[2];
        this.user = (Double)values[3];
        this.system = (Double)values[4];
        this.wait = (Double)values[5];
        this.nice = (Double)values[6];
        this.irq = (Double)values[7];
        this.totalUtilization = (Double)values[8];
        this.idle = (Double)values[9];
    }

    protected CPUUtilizationRecord(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.timestamp = (Long)values[0];
        this.hostname = (String)values[1];
        this.cpuID = (String)values[2];
        this.user = (Double)values[3];
        this.system = (Double)values[4];
        this.wait = (Double)values[5];
        this.nice = (Double)values[6];
        this.irq = (Double)values[7];
        this.totalUtilization = (Double)values[8];
        this.idle = (Double)values[9];
    }

    public CPUUtilizationRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.timestamp = buffer.getLong();
        this.hostname = stringRegistry.get(buffer.getInt());
        this.cpuID = stringRegistry.get(buffer.getInt());
        this.user = buffer.getDouble();
        this.system = buffer.getDouble();
        this.wait = buffer.getDouble();
        this.nice = buffer.getDouble();
        this.irq = buffer.getDouble();
        this.totalUtilization = buffer.getDouble();
        this.idle = buffer.getDouble();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getHostname(), this.getCpuID(), this.getUser(), this.getSystem(), this.getWait(), this.getNice(), this.getIrq(), this.getTotalUtilization(), this.getIdle()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(stringRegistry.get(this.getCpuID()));
        buffer.putDouble(this.getUser());
        buffer.putDouble(this.getSystem());
        buffer.putDouble(this.getWait());
        buffer.putDouble(this.getNice());
        buffer.putDouble(this.getIrq());
        buffer.putDouble(this.getTotalUtilization());
        buffer.putDouble(this.getIdle());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 72;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getCpuID() {
        return this.cpuID;
    }

    public final double getUser() {
        return this.user;
    }

    public final double getSystem() {
        return this.system;
    }

    public final double getWait() {
        return this.wait;
    }

    public final double getNice() {
        return this.nice;
    }

    public final double getIrq() {
        return this.irq;
    }

    public final double getTotalUtilization() {
        return this.totalUtilization;
    }

    public final double getIdle() {
        return this.idle;
    }
}

