/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.jvm.AbstractJVMRecord;
import kieker.common.util.registry.IRegistry;

public class UptimeRecord
extends AbstractJVMRecord {
    public static final int SIZE = 24;
    private static final long serialVersionUID = 1869471516324654958L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Long.TYPE};
    private final long uptimeMS;

    public UptimeRecord(long timestamp, String hostname, String vmName, long uptimeMS) {
        super(timestamp, hostname, vmName);
        this.uptimeMS = uptimeMS;
    }

    public UptimeRecord(Object[] values) {
        super(values, TYPES);
        this.uptimeMS = (Long)values[3];
    }

    protected UptimeRecord(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.uptimeMS = (Long)values[3];
    }

    public UptimeRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.uptimeMS = buffer.getLong();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getHostname(), this.getVmName(), this.getUptimeMS()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(stringRegistry.get(this.getVmName()));
        buffer.putLong(this.getUptimeMS());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 24;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final long getUptimeMS() {
        return this.uptimeMS;
    }
}

