/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation.constructor.object;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.flow.ICallObjectRecord;
import kieker.common.record.flow.trace.operation.constructor.CallConstructorEvent;
import kieker.common.util.registry.IRegistry;

public class CallConstructorObjectEvent
extends CallConstructorEvent
implements ICallObjectRecord {
    public static final int SIZE = 44;
    private static final long serialVersionUID = -3991606008605176780L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE};
    private final int objectId;
    private final int calleeObjectId;

    public CallConstructorObjectEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String calleeOperationSignature, String calleeClassSignature, int objectId, int calleeObjectId) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature, calleeOperationSignature, calleeClassSignature);
        this.objectId = objectId;
        this.calleeObjectId = calleeObjectId;
    }

    public CallConstructorObjectEvent(Object[] values) {
        super(values, TYPES);
        this.objectId = (Integer)values[7];
        this.calleeObjectId = (Integer)values[8];
    }

    protected CallConstructorObjectEvent(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.objectId = (Integer)values[7];
        this.calleeObjectId = (Integer)values[8];
    }

    public CallConstructorObjectEvent(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.objectId = buffer.getInt();
        this.calleeObjectId = buffer.getInt();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getTraceId(), this.getOrderIndex(), this.getOperationSignature(), this.getClassSignature(), this.getCalleeOperationSignature(), this.getCalleeClassSignature(), this.getObjectId(), this.getCalleeObjectId()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putLong(this.getTraceId());
        buffer.putInt(this.getOrderIndex());
        buffer.putInt(stringRegistry.get(this.getOperationSignature()));
        buffer.putInt(stringRegistry.get(this.getClassSignature()));
        buffer.putInt(stringRegistry.get(this.getCalleeOperationSignature()));
        buffer.putInt(stringRegistry.get(this.getCalleeClassSignature()));
        buffer.putInt(this.getObjectId());
        buffer.putInt(this.getCalleeObjectId());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 44;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int getObjectId() {
        return this.objectId;
    }

    @Override
    public final int getCallerObjectId() {
        return this.getObjectId();
    }

    @Override
    public final int getCalleeObjectId() {
        return this.calleeObjectId;
    }
}

