/*
 * Decompiled with CFR 0.152.
 */
package kieker.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.ILookup;
import kieker.common.util.registry.Lookup;
import kieker.tcp.TCPStringReader;

@Plugin(description="A reader which reads records from a TCP port", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the TCPReader")}, configuration={@Property(name="port1", defaultValue="10133", description="The first port of the server used for the TCP connection."), @Property(name="port2", defaultValue="10134", description="The second port of the server used for the TCP connection.")})
final class TCPCountingReader
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_PORT1 = "port1";
    public static final String CONFIG_PROPERTY_NAME_PORT2 = "port2";
    private static final int MESSAGE_BUFFER_SIZE = 65535;
    static final Log LOG = LogFactory.getLog(TCPCountingReader.class);
    private final int port1;
    private final int port2;
    private final ILookup<String> stringRegistry = new Lookup();
    final AtomicInteger counter = new AtomicInteger(0);

    public TCPCountingReader(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.port1 = this.configuration.getIntProperty(CONFIG_PROPERTY_NAME_PORT1);
        this.port2 = this.configuration.getIntProperty(CONFIG_PROPERTY_NAME_PORT2);
    }

    public boolean init() {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        executorService.scheduleAtFixedRate(new Runnable(){

            public void run() {
                LOG.info("Records/s: " + TCPCountingReader.this.counter.getAndSet(0));
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        TCPStringReader tcpStringReader = new TCPStringReader(this.port2, this.stringRegistry);
        tcpStringReader.start();
        return super.init();
    }

    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_PORT1, Integer.toString(this.port1));
        configuration.setProperty(CONFIG_PROPERTY_NAME_PORT2, Integer.toString(this.port2));
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean read() {
        ServerSocketChannel serversocket = null;
        try {
            serversocket = ServerSocketChannel.open();
            serversocket.socket().bind(new InetSocketAddress(this.port1));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Listening on port " + this.port1);
            }
            SocketChannel socketChannel = serversocket.accept();
            ByteBuffer buffer = ByteBuffer.allocateDirect(65535);
            while (true) {
                if (socketChannel.read(buffer) == -1) {
                    socketChannel.close();
                    return true;
                }
                buffer.flip();
                try {
                    while (buffer.hasRemaining()) {
                        buffer.mark();
                        int clazzid = buffer.getInt();
                        long loggingTimestamp = buffer.getLong();
                        try {
                            IMonitoringRecord record = AbstractMonitoringRecord.createFromByteBuffer((int)clazzid, (ByteBuffer)buffer, this.stringRegistry);
                            record.setLoggingTimestamp(loggingTimestamp);
                            this.counter.incrementAndGet();
                        }
                        catch (MonitoringRecordException ex) {
                            LOG.error("Failed to create record.", (Throwable)ex);
                        }
                    }
                    buffer.clear();
                }
                catch (BufferUnderflowException ex) {
                    buffer.reset();
                    buffer.compact();
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Error while reading", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            block20: {
                if (null != serversocket) {
                    try {
                        serversocket.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block20;
                        LOG.debug("Failed to close TCP connection!", (Throwable)e);
                    }
                }
            }
        }
    }

    public void terminate(boolean error) {
        LOG.info("Shutdown of TCPReader requested.");
    }
}

