/*
 * Decompiled with CFR 0.152.
 */
package mooBench.monitoredApplication;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.timer.ITimeSource;
import mooBench.monitoredApplication.MonitoredClass;

public final class MonitoredClassManualInstrumentation
implements MonitoredClass {
    private static final String SIGNATURE = "public final long mooBench.monitoredApplication.MonitoredClass.monitoredMethod(long, int)";
    private static final String CLAZZ = "mooBench.monitoredApplication.MonitoredClass";
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;
    final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public final long monitoredMethod(long methodTime, int recDepth) {
        long retval;
        boolean newTrace = MonitoredClassManualInstrumentation.triggerBefore();
        if (recDepth > 1) {
            retval = this.monitoredMethod(methodTime, recDepth - 1);
        } else {
            long currentTime;
            long exitTime = this.threadMXBean.getCurrentThreadUserTime() + methodTime;
            while ((currentTime = this.threadMXBean.getCurrentThreadUserTime()) < exitTime) {
            }
            retval = currentTime;
        }
        MonitoredClassManualInstrumentation.triggerAfter(newTrace);
        return retval;
    }

    private static final boolean triggerBefore() {
        boolean newTrace;
        if (!CTRLINST.isMonitoringEnabled()) {
            return false;
        }
        String signature = SIGNATURE;
        if (!CTRLINST.isProbeActivated(SIGNATURE)) {
            return false;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        boolean bl = newTrace = trace == null;
        if (newTrace) {
            trace = TRACEREGISTRY.registerTrace();
            CTRLINST.newMonitoringRecord((IMonitoringRecord)trace);
        }
        long traceId = trace.getTraceId();
        String clazz = CLAZZ;
        CTRLINST.newMonitoringRecord((IMonitoringRecord)new BeforeOperationEvent(TIME.getTime(), traceId, trace.getNextOrderId(), SIGNATURE, CLAZZ));
        return newTrace;
    }

    private static final void triggerAfter(boolean newTrace) {
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        if (null != trace) {
            String signature = SIGNATURE;
            String clazz = CLAZZ;
            CTRLINST.newMonitoringRecord((IMonitoringRecord)new AfterOperationEvent(TIME.getTime(), trace.getTraceId(), trace.getNextOrderId(), SIGNATURE, CLAZZ));
            if (newTrace) {
                TRACEREGISTRY.unregisterTrace();
            }
        }
    }
}

