/*
 * Decompiled with CFR 0.152.
 */
package mooBench.benchmark;

import java.util.concurrent.CountDownLatch;
import mooBench.benchmark.BenchmarkingThread;
import mooBench.monitoredApplication.MonitoredClass;

public final class BenchmarkingThreadNano
implements BenchmarkingThread {
    private final MonitoredClass mc;
    private final CountDownLatch doneSignal;
    private final int totalCalls;
    private final long methodTime;
    private final int recursionDepth;
    private final long[] timings;

    public BenchmarkingThreadNano(MonitoredClass mc, int totalCalls, long methodTime, int recursionDepth, CountDownLatch doneSignal) {
        this.mc = mc;
        this.doneSignal = doneSignal;
        this.totalCalls = totalCalls;
        this.methodTime = methodTime;
        this.recursionDepth = recursionDepth;
        this.timings = new long[totalCalls];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long[] getTimings() {
        BenchmarkingThreadNano benchmarkingThreadNano = this;
        synchronized (benchmarkingThreadNano) {
            return this.timings;
        }
    }

    public final void run() {
        for (int i = 0; i < this.totalCalls; ++i) {
            long start_ns = System.nanoTime();
            this.mc.monitoredMethod(this.methodTime, this.recursionDepth);
            long stop_ns = System.nanoTime();
            this.timings[i] = stop_ns - start_ns;
            if (i % 100000 != 0) continue;
            System.out.println(i);
        }
        this.doneSignal.countDown();
    }
}

