/*
 * Decompiled with CFR 0.152.
 */
package kieker.tcp;

import java.util.concurrent.TimeUnit;
import kieker.analysis.AnalysisController;
import kieker.analysis.IAnalysisController;
import kieker.analysis.IProjectContext;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.filter.flow.EventRecordTraceReconstructionFilter;
import kieker.analysis.plugin.filter.forward.AnalysisThroughputFilter;
import kieker.analysis.plugin.filter.forward.TeeFilter;
import kieker.analysis.plugin.reader.tcp.TCPReader;
import kieker.analysis.plugin.reader.timer.TimeReader;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

public final class TestExperiment2 {
    private static final Log LOG = LogFactory.getLog(TestExperiment2.class);

    private TestExperiment2() {
    }

    public static void main(String[] args) throws IllegalStateException, AnalysisConfigurationException {
        AnalysisController analysisController = new AnalysisController("TCPThroughput");
        TestExperiment2.createAndConnectPlugins((IAnalysisController)analysisController);
        try {
            analysisController.run();
        }
        catch (AnalysisConfigurationException ex) {
            LOG.error("Failed to start the example project.", (Throwable)ex);
        }
    }

    private static void createAndConnectPlugins(IAnalysisController analysisController) throws IllegalStateException, AnalysisConfigurationException {
        Configuration readerConfig = new Configuration();
        TCPReader reader = new TCPReader(readerConfig, (IProjectContext)analysisController);
        Configuration timeConfig = new Configuration();
        TimeReader timeReader = new TimeReader(timeConfig, (IProjectContext)analysisController);
        Configuration configTraceRecon = new Configuration();
        configTraceRecon.setProperty("timeunit", TimeUnit.SECONDS.name());
        configTraceRecon.setProperty("maxTraceDuration", "1");
        configTraceRecon.setProperty("maxTraceTimeout", "1");
        EventRecordTraceReconstructionFilter traceRecon = new EventRecordTraceReconstructionFilter(configTraceRecon, (IProjectContext)analysisController);
        analysisController.connect((AbstractPlugin)reader, "monitoringRecords", (AbstractPlugin)traceRecon, "traceRecords");
        analysisController.connect((AbstractPlugin)timeReader, "timestamps", (AbstractPlugin)traceRecon, "timestamps");
        Configuration counterConfig = new Configuration();
        AnalysisThroughputFilter through = new AnalysisThroughputFilter(counterConfig, (IProjectContext)analysisController);
        analysisController.connect((AbstractPlugin)traceRecon, "validTraces", (AbstractPlugin)through, "inputObjects");
        analysisController.connect((AbstractPlugin)timeReader, "timestamps", (AbstractPlugin)through, "inputTime");
        Configuration confTeeFilter = new Configuration();
        confTeeFilter.setProperty("stream", "STDOUT");
        TeeFilter teeFilter = new TeeFilter(confTeeFilter, (IProjectContext)analysisController);
        analysisController.connect((AbstractPlugin)through, "throughput", (AbstractPlugin)teeFilter, "receivedEvents");
    }
}

