/*
 * Decompiled with CFR 0.152.
 */
package kieker.examples.userguide.appendixJMS;

import kieker.analysis.AnalysisController;
import kieker.analysis.IProjectContext;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.AbstractPlugin;
import kieker.analysis.plugin.filter.forward.TeeFilter;
import kieker.analysis.plugin.reader.jms.JMSReader;
import kieker.common.configuration.Configuration;

public final class JMSAnalysisStarter {
    private static final String CONNECTION_FACTORY_TYPE__ACTIVEMQ = "org.apache.activemq.jndi.ActiveMQInitialContextFactory";
    private static final String CONNECTION_FACTORY_TYPE__HORNETQ = "org.jnp.interfaces.NamingContextFactory";
    private static final String CONNECTION_FACTORY_TYPE__OPENJMS = "org.exolab.jms.jndi.InitialContextFactory";
    private static final String PROVIDER_URL__ACTIVEMQ = "tcp://127.0.0.1:61616/";
    private static final String PROVIDER_URL__HORNETQ = "jnp://localhost:1099/";
    private static final String PROVIDER_URL__OPENJMS = "tcp://127.0.0.1:3035/";
    private static final String QUEUE_ACTIVEMQ = "queue1";
    private static final String QUEUE_HORNETQ = "queue1";
    private static final String QUEUE_OPENJMS = "queue1";
    private static String connectionFactory;
    private static String providerUrl;
    private static String queue;

    private JMSAnalysisStarter() {
    }

    public static void main(String[] stringArray) {
        if (!JMSAnalysisStarter.parseArguments(stringArray)) {
            JMSAnalysisStarter.printUsage();
            System.exit(1);
        }
        AnalysisController analysisController = new AnalysisController();
        Configuration configuration = new Configuration();
        configuration.setProperty("jmsProviderUrl", providerUrl);
        configuration.setProperty("jmsFactoryLookupName", connectionFactory);
        configuration.setProperty("jmsDestination", queue);
        JMSReader jMSReader = new JMSReader(configuration, (IProjectContext)analysisController);
        TeeFilter teeFilter = new TeeFilter(new Configuration(), (IProjectContext)analysisController);
        try {
            analysisController.connect((AbstractPlugin)jMSReader, "monitoringRecords", (AbstractPlugin)teeFilter, "receivedEvents");
            analysisController.run();
        }
        catch (AnalysisConfigurationException analysisConfigurationException) {
            analysisConfigurationException.printStackTrace();
        }
    }

    private static boolean parseArguments(String[] stringArray) {
        if (stringArray.length != 3) {
            System.err.println("Invalid number of arguments: " + stringArray.length);
            return false;
        }
        connectionFactory = stringArray[0];
        System.out.println("jms-connection-factory:" + connectionFactory);
        providerUrl = stringArray[1];
        System.out.println("jms-provider-url:      " + providerUrl);
        queue = stringArray[2];
        System.out.println("jms-queue:             " + queue);
        System.out.println();
        return true;
    }

    private static void printUsage() {
        System.out.println("Usage: " + JMSAnalysisStarter.class.getName() + " <jms-connection-factory> <jms-provider-url> <jms-queue>");
        System.out.println();
        System.out.println("Examples:");
        System.out.println(" - ActiveMQ: org.apache.activemq.jndi.ActiveMQInitialContextFactory tcp://127.0.0.1:61616/ queue1");
        System.out.println(" - HornetQ:  org.jnp.interfaces.NamingContextFactory jnp://localhost:1099/ queue1");
        System.out.println(" - OpenJMS:  org.exolab.jms.jndi.InitialContextFactory tcp://127.0.0.1:3035/ queue1");
    }
}

