/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.XPathUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathPanel
extends JPanel {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JCheckBox negated;
    private JTextField xpath;
    private JButton checkXPath;

    public XPathPanel() {
        this.init();
    }

    private void init() {
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalGlue());
        hbox.add(this.getXPathTextField());
        hbox.add(Box.createHorizontalGlue());
        hbox.add(this.getCheckXPathButton());
        Box vbox = Box.createVerticalBox();
        vbox.add(hbox);
        vbox.add(Box.createVerticalGlue());
        vbox.add(this.getNegatedCheckBox());
        this.add(vbox);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.setXPath("/");
        this.setNegated(false);
    }

    public String getXPath() {
        return this.xpath.getText();
    }

    public void setXPath(String xpath) {
        this.xpath.setText(xpath);
    }

    public boolean isNegated() {
        return this.negated.isSelected();
    }

    public void setNegated(boolean negated) {
        this.negated.setSelected(negated);
    }

    public JCheckBox getNegatedCheckBox() {
        if (this.negated == null) {
            this.negated = new JCheckBox(JMeterUtils.getResString((String)"xpath_assertion_negate"), false);
        }
        return this.negated;
    }

    public JButton getCheckXPathButton() {
        if (this.checkXPath == null) {
            this.checkXPath = new JButton(JMeterUtils.getResString((String)"xpath_assertion_button"));
            this.checkXPath.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    XPathPanel.validXPath(XPathPanel.this.xpath.getText(), true);
                }
            });
        }
        return this.checkXPath;
    }

    public JTextField getXPathTextField() {
        if (this.xpath == null) {
            this.xpath = new JTextField(50);
        }
        return this.xpath;
    }

    public boolean isShowNegated() {
        return this.getNegatedCheckBox().isVisible();
    }

    public void setShowNegated(boolean showNegate) {
        this.getNegatedCheckBox().setVisible(showNegate);
    }

    public static boolean validXPath(String xpathString, boolean showDialog) {
        String ret = null;
        boolean success = true;
        Document testDoc = null;
        try {
            testDoc = XPathUtil.makeDocumentBuilder((boolean)false, (boolean)false, (boolean)false, (boolean)false).newDocument();
            Element el = testDoc.createElement("root");
            testDoc.appendChild(el);
            XPathUtil.validateXPath((Document)testDoc, (String)xpathString);
        }
        catch (IllegalArgumentException e) {
            log.warn(e.getLocalizedMessage());
            success = false;
            ret = e.getLocalizedMessage();
        }
        catch (ParserConfigurationException e) {
            success = false;
            ret = e.getLocalizedMessage();
        }
        catch (TransformerException e) {
            success = false;
            ret = e.getLocalizedMessage();
        }
        if (showDialog) {
            JOptionPane.showMessageDialog(null, success ? JMeterUtils.getResString((String)"xpath_assertion_valid") : ret, success ? JMeterUtils.getResString((String)"xpath_assertion_valid") : JMeterUtils.getResString((String)"xpath_assertion_failed"), success ? 1 : 0);
        }
        return success;
    }
}

