/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.record;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.util.registry.IRegistry;
import kieker.tools.opad.record.StorableDetectionResult;

public class ExtendedStorableDetectionResult
extends StorableDetectionResult {
    public static final int SIZE = 44;
    private static final long serialVersionUID = 5201527358214171119L;
    public static final Class<?>[] TYPES = new Class[]{String.class, Double.TYPE, Long.TYPE, Double.TYPE, Double.TYPE, Double.TYPE};
    private final double anomalyThreshold;

    public ExtendedStorableDetectionResult(String applicationName, double value, long timestamp, double forecast, double score, double anomalyThreshold) {
        super(applicationName, value, timestamp, forecast, score);
        this.anomalyThreshold = anomalyThreshold;
    }

    public ExtendedStorableDetectionResult(Object[] values) {
        super(values, TYPES);
        this.anomalyThreshold = (Double)values[5];
    }

    protected ExtendedStorableDetectionResult(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.anomalyThreshold = (Double)values[5];
    }

    public ExtendedStorableDetectionResult(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.anomalyThreshold = buffer.getDouble();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getApplicationName(), this.getValue(), this.getTimestamp(), this.getForecast(), this.getScore(), this.getAnomalyThreshold()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putInt(stringRegistry.get(this.getApplicationName()));
        buffer.putDouble(this.getValue());
        buffer.putLong(this.getTimestamp());
        buffer.putDouble(this.getForecast());
        buffer.putDouble(this.getScore());
        buffer.putDouble(this.getAnomalyThreshold());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 44;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final double getAnomalyThreshold() {
        return this.anomalyThreshold;
    }
}

