/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.filter;

import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.tools.opad.model.NamedDoubleTimeSeriesPoint;
import kieker.tools.opad.record.NamedDoubleRecord;

@Plugin(outputPorts={@OutputPort(name="outputData", eventTypes={NamedDoubleTimeSeriesPoint.class})}, configuration={@Property(name="timeunit", defaultValue="NANOSECONDS")})
public class ExtractionFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_VALUE = "inputRecord";
    public static final String OUTPUT_PORT_NAME_VALUE = "outputData";
    public static final String CONFIG_PROPERTY_NAME_TIMEUNIT = "timeunit";
    public static final String CONFIG_PROPERTY_VALUE_TIMEUNIT = "NANOSECONDS";
    private final TimeUnit timeunit;

    public ExtractionFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        TimeUnit configTimeunit;
        try {
            configTimeunit = TimeUnit.valueOf(configuration.getStringProperty(CONFIG_PROPERTY_NAME_TIMEUNIT));
        }
        catch (IllegalArgumentException ex) {
            configTimeunit = TimeUnit.NANOSECONDS;
        }
        this.timeunit = configTimeunit;
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_TIMEUNIT, this.timeunit.name());
        return configuration;
    }

    @InputPort(name="inputRecord", eventTypes={NamedDoubleRecord.class})
    public void inputExecutionRecord(NamedDoubleRecord record) {
        long timestampMillis = this.timeunit.convert(record.getTimestamp(), this.recordsTimeUnitFromProjectContext);
        NamedDoubleTimeSeriesPoint tspoint = new NamedDoubleTimeSeriesPoint(timestampMillis, record.getResponseTime(), record.getApplicationName());
        super.deliver(OUTPUT_PORT_NAME_VALUE, tspoint);
    }
}

