/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.jms;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.concurrent.BlockingQueue;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.AbstractAsyncThread;

final class JMSWriterThread
extends AbstractAsyncThread {
    private static final Log LOG = LogFactory.getLog(JMSWriterThread.class);
    private Session session;
    private Connection connection;
    private MessageProducer sender;

    public JMSWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, String contextFactoryType, String providerUrl, String factoryLookupName, String topic, long messageTimeToLive) throws Exception {
        super(monitoringController, writeQueue);
        try {
            Destination destination;
            block5: {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                properties.put("java.naming.factory.initial", contextFactoryType);
                properties.put("java.naming.provider.url", providerUrl);
                InitialContext context = new InitialContext(properties);
                ConnectionFactory factory = (ConnectionFactory)context.lookup(factoryLookupName);
                this.connection = factory.createConnection();
                this.session = this.connection.createSession(false, 1);
                this.connection.start();
                try {
                    destination = (Destination)context.lookup(topic);
                }
                catch (NameNotFoundException exc) {
                    destination = this.session.createQueue(topic);
                    if (destination != null) break block5;
                    LOG.error("Failed to lookup queue '" + topic + "' via JNDI: " + exc.getMessage() + " AND failed to create queue");
                    throw exc;
                }
            }
            this.sender = this.session.createProducer(destination);
            this.sender.setDeliveryMode(1);
            this.sender.setDisableMessageID(false);
            this.sender.setTimeToLive(messageTimeToLive);
        }
        catch (NamingException ex) {
            throw new Exception("NamingException Exception while initializing JMS Writer", ex);
        }
        catch (JMSException ex) {
            throw new Exception("JMSException Exception while initializing JMS Writer", ex);
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(super.toString());
        sb.append("; Session: '");
        sb.append(this.session.toString());
        sb.append("'; Connection: '");
        sb.append(this.connection.toString());
        sb.append("'; MessageProducer: '");
        sb.append(this.sender.toString());
        sb.append('\'');
        return sb.toString();
    }

    @Override
    protected final void consume(IMonitoringRecord monitoringRecord) throws Exception {
        try {
            this.sender.send((Message)this.session.createObjectMessage((Serializable)monitoringRecord));
        }
        catch (JMSException ex) {
            throw new Exception("Error sending jms message", ex);
        }
    }

    @Override
    protected final void cleanup() {
        try {
            if (this.sender != null) {
                this.sender.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException ex) {
            LOG.error("Error closing connection", ex);
        }
    }
}

