/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem.async;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.filesystem.async.AbstractZipWriterThread;
import kieker.monitoring.writer.filesystem.map.StringMappingFileWriter;

public class BinaryZipWriterThread
extends AbstractZipWriterThread {
    private final DataOutputStream out;
    private final IRegistry<String> stringRegistry;

    public BinaryZipWriterThread(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, StringMappingFileWriter mappingFileWriter, String path, int maxEntriesInFile, int bufferSize, int level) throws IOException {
        super(monitoringController, writeQueue, mappingFileWriter, path, maxEntriesInFile, level);
        this.fileExtension = ".bin";
        this.out = new DataOutputStream(new BufferedOutputStream(this.zipOutputStream, bufferSize));
        this.stringRegistry = monitoringController.getStringRegistry();
    }

    @Override
    protected void write(IMonitoringRecord monitoringRecord) throws IOException {
        int size = monitoringRecord.getSize() + 4 + 8;
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        buffer.putInt(this.monitoringController.getUniqueIdForString(monitoringRecord.getClass().getName()));
        buffer.putLong(monitoringRecord.getLoggingTimestamp());
        monitoringRecord.writeBytes(buffer, this.stringRegistry);
        byte[] bytes = new byte[size];
        buffer.flip();
        buffer.get(bytes, 0, size);
        this.out.write(bytes);
    }

    @Override
    protected void cleanupForNextEntry() throws IOException {
        this.out.flush();
    }

    @Override
    protected void cleanupFinal() throws IOException {
        this.out.close();
    }
}

