/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.util.concurrent.BlockingQueue;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.filesystem.AbstractAsyncFSWriter;
import kieker.monitoring.writer.filesystem.async.AbstractFsWriterThread;
import kieker.monitoring.writer.filesystem.async.BinaryNFsWriterThread;
import kieker.monitoring.writer.filesystem.map.MappingFileWriter;

public final class AsyncBinaryNFsWriter
extends AbstractAsyncFSWriter {
    private static final String PREFIX = AsyncBinaryNFsWriter.class.getName() + ".";
    public static final String CONFIG_BUFFER = PREFIX + "bufferSize";
    public static final String CONFIG_COMPRESS = PREFIX + "compress";
    private static final Log LOG = LogFactory.getLog(AsyncBinaryNFsWriter.class);
    private final int buffersize;

    public AsyncBinaryNFsWriter(Configuration configuration) {
        super(configuration);
        int tmpBuffersize = configuration.getIntProperty(CONFIG_BUFFER);
        if (tmpBuffersize <= 0) {
            LOG.warn("Buffer size has to be greater than zero. Using 65535 instead.");
            tmpBuffersize = 65535;
        }
        this.buffersize = tmpBuffersize;
    }

    @Override
    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration(super.getDefaultConfiguration());
        configuration.setProperty(CONFIG_BUFFER, "65535");
        configuration.setProperty(CONFIG_COMPRESS, "NONE");
        return configuration;
    }

    @Override
    protected final AbstractFsWriterThread initWorker(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, MappingFileWriter mappingFileWriter, String path, int maxEntiresInFile, int maxlogSize, int maxLogFiles) {
        return new BinaryNFsWriterThread(monitoringController, writeQueue, mappingFileWriter, path, maxEntiresInFile, maxlogSize, maxLogFiles, this.buffersize);
    }
}

