/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.registry;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kieker.common.record.misc.RegistryRecord;
import kieker.common.util.registry.IMonitoringRecordReceiver;
import kieker.common.util.registry.IRegistry;

public final class Registry<E>
implements IRegistry<E> {
    private static final int INITIAL_CAPACITY = 16;
    private static final double LOAD_FACTOR = 0.75;
    private static final int CONCURRENCY_LEVEL = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private final int segmentMask;
    private final int segmentShift;
    private final Segment<E>[] segments;
    private final AtomicInteger nextId = new AtomicInteger(0);
    private volatile E[] eArrayCached;

    public Registry() {
        int cap;
        int ssize;
        int sshift = 0;
        for (ssize = 1; ssize < 16; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        int c = 16 / ssize;
        if (c * ssize < 16) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, 0.75);
        }
        this.eArrayCached = new Object[0];
    }

    private static final int hash(Object value) {
        int h = value.hashCode();
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    @Override
    public final void setRecordReceiver(IMonitoringRecordReceiver recordReceiver) {
        for (Segment<E> segment : this.segments) {
            segment.setRecordReceiver(recordReceiver);
        }
    }

    @Override
    public final int get(E value) {
        int hash = Registry.hash(value);
        return this.segments[hash >>> this.segmentShift & this.segmentMask].get(value, hash, this.nextId);
    }

    @Override
    public final E get(int id) {
        int capacity = this.nextId.get();
        if (id > capacity) {
            return null;
        }
        if (this.eArrayCached.length != capacity) {
            Object[] eArray = new Object[capacity];
            for (Segment<Object> segment : this.segments) {
                segment.insertIntoArray(eArray);
            }
            this.eArrayCached = eArray;
        }
        return this.eArrayCached[id];
    }

    @Override
    public final E[] getAll() {
        int capacity = this.nextId.get();
        if (this.eArrayCached.length != capacity) {
            Object[] eArray = new Object[capacity];
            for (Segment<Object> segment : this.segments) {
                segment.insertIntoArray(eArray);
            }
            this.eArrayCached = eArray;
        }
        return Arrays.copyOf(this.eArrayCached, capacity);
    }

    @Override
    public final int getSize() {
        return this.nextId.get();
    }

    public final void remove(E value) {
        int hash = Registry.hash(value);
        this.segments[hash >>> this.segmentShift & this.segmentMask].remove(value, hash);
        this.eArrayCached = new Object[0];
    }

    public final void clear() {
        for (Segment<E> segment : this.segments) {
            segment.clear();
        }
        this.eArrayCached = new Object[0];
    }

    private static final class Segment<E>
    extends ReentrantLock {
        private static final long serialVersionUID = 1L;
        private volatile int count;
        private HashEntry<E>[] table;
        private int threshold;
        private transient IMonitoringRecordReceiver recordReceiver;

        protected Segment(int initialCapacity, double lf) {
            this.table = new HashEntry[initialCapacity];
            this.threshold = (int)((double)initialCapacity * lf);
            this.count = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void setRecordReceiver(IMonitoringRecordReceiver recordReceiver) {
            this.lock();
            try {
                this.recordReceiver = recordReceiver;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void insertIntoArray(E[] eArray) {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<E>[] tab;
                    int capacity = eArray.length;
                    HashEntry<E>[] arr$ = tab = this.table;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        HashEntry<E> hashEntry;
                        HashEntry<E> e = hashEntry = arr$[i$];
                        while (e != null) {
                            if (e.id < capacity) {
                                eArray[e.id] = e.value;
                            }
                            e = e.next;
                        }
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final int get(E value, int hash, AtomicInteger nextId) {
            HashEntry<E> e = null;
            if (this.count != 0) {
                HashEntry<E> first;
                HashEntry<E>[] tab = this.table;
                int index = hash & tab.length - 1;
                e = first = tab[index];
                while (!(e == null || e.hash == hash && value.equals(e.value))) {
                    e = e.next;
                }
            }
            if (e == null) {
                this.lock();
                try {
                    HashEntry<E> first;
                    int c = this.count + 1;
                    if (c >= this.threshold) {
                        this.rehash();
                        this.count = c;
                    }
                    HashEntry<E>[] tab = this.table;
                    int index = hash & tab.length - 1;
                    e = first = tab[index];
                    while (!(e == null || e.hash == hash && value.equals(e.value))) {
                        e = e.next;
                    }
                    if (e == null) {
                        int id = nextId.getAndIncrement();
                        tab[index] = new HashEntry<E>(value, hash, id, first);
                        this.count = c;
                        if (this.recordReceiver != null) {
                            this.recordReceiver.newMonitoringRecord(new RegistryRecord(id, (String)value));
                        }
                        int n = id;
                        return n;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            return e.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void remove(E value, int hash) {
            this.lock();
            try {
                HashEntry<E> first;
                int c = this.count - 1;
                HashEntry<E>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<E> e = first = tab[index];
                while (!(e == null || e.hash == hash && value.equals(e.value))) {
                    e = e.next;
                }
                if (e != null) {
                    HashEntry newFirst = e.next;
                    HashEntry<E> p = first;
                    while (p != e) {
                        newFirst = new HashEntry(p.value, p.hash, p.id, newFirst);
                        p = p.next;
                    }
                    tab[index] = newFirst;
                    this.count = c;
                }
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<E>[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }

        private final void rehash() {
            HashEntry<E>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = new HashEntry[oldCapacity << 1];
            this.threshold = (int)((double)newTable.length * 0.75);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                HashEntry<E> e = oldTable[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry<E> lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry<E> p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry(p.value, p.hash, p.id, n);
                    p = p.next;
                }
            }
            this.table = newTable;
        }
    }

    private static final class HashEntry<E>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final E value;
        final int hash;
        final int id;
        final HashEntry<E> next;

        protected HashEntry(E value, int hash, int id, HashEntry<E> next) {
            this.value = value;
            this.hash = hash;
            this.id = id;
            this.next = next;
        }
    }
}

