/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.flow.IExceptionRecord;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.util.registry.IRegistry;

public class AfterOperationFailedEvent
extends AfterOperationEvent
implements IExceptionRecord {
    public static final int SIZE = 32;
    private static final long serialVersionUID = -7300825614065386027L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class};
    private final String cause;

    public AfterOperationFailedEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String cause) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature);
        this.cause = cause == null ? "" : cause;
    }

    public AfterOperationFailedEvent(Object[] values) {
        super(values, TYPES);
        this.cause = (String)values[5];
    }

    protected AfterOperationFailedEvent(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.cause = (String)values[5];
    }

    public AfterOperationFailedEvent(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.cause = stringRegistry.get(buffer.getInt());
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getTraceId(), this.getOrderIndex(), this.getOperationSignature(), this.getClassSignature(), this.getCause()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putLong(this.getTraceId());
        buffer.putInt(this.getOrderIndex());
        buffer.putInt(stringRegistry.get(this.getOperationSignature()));
        buffer.putInt(stringRegistry.get(this.getClassSignature()));
        buffer.putInt(stringRegistry.get(this.getCause()));
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getCause() {
        return this.cause;
    }
}

