/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.logging;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

public final class LogImplJUnit
implements Log {
    private static final Log LOG = LogFactory.getLog(LogImplJUnit.class);
    private static final Set<Class<? extends Throwable>> DISABLED_THROWABLES = new HashSet<Class<? extends Throwable>>();
    private final Logger logger;
    private final String name;

    protected LogImplJUnit(String name) {
        this.name = name;
        this.logger = Logger.getLogger(name);
    }

    private final void log(Level level, String message, Throwable t) {
        if (this.logger.isLoggable(level)) {
            String sourceClass = this.name;
            StackTraceElement[] stackArray = new Throwable().getStackTrace();
            String sourceMethod = stackArray.length > 2 ? stackArray[2].getMethodName() : "unknown";
            if (t != null) {
                this.logger.logp(level, sourceClass, sourceMethod, message, t);
            } else {
                this.logger.logp(level, sourceClass, sourceMethod, message);
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public void trace(String message) {
        this.log(Level.FINER, message, null);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.log(Level.FINER, message, t);
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public final void debug(String message) {
        this.log(Level.FINE, message, null);
    }

    @Override
    public final void debug(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    @Override
    public final void info(String message) {
        this.log(Level.INFO, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void info(String message, Throwable t) {
        Set<Class<? extends Throwable>> set = DISABLED_THROWABLES;
        synchronized (set) {
            for (Class<? extends Throwable> clazz : DISABLED_THROWABLES) {
                if (!clazz.isInstance(t)) continue;
                this.log(Level.FINE, message, t);
                return;
            }
        }
        this.log(Level.INFO, message, t);
    }

    @Override
    public final void warn(String message) {
        this.log(Level.WARNING, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void warn(String message, Throwable t) {
        Set<Class<? extends Throwable>> set = DISABLED_THROWABLES;
        synchronized (set) {
            for (Class<? extends Throwable> clazz : DISABLED_THROWABLES) {
                if (!clazz.isInstance(t)) continue;
                this.debug(message, t);
                this.log(Level.FINE, message, t);
                return;
            }
        }
        this.log(Level.WARNING, message, t);
    }

    @Override
    public final void error(String message) {
        this.log(Level.SEVERE, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void error(String message, Throwable t) {
        Set<Class<? extends Throwable>> set = DISABLED_THROWABLES;
        synchronized (set) {
            for (Class<? extends Throwable> clazz : DISABLED_THROWABLES) {
                if (!clazz.isInstance(t)) continue;
                this.log(Level.FINE, message, t);
                return;
            }
        }
        this.log(Level.SEVERE, message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void disableThrowable(Class<? extends Throwable> clazz) {
        Set<Class<? extends Throwable>> set = DISABLED_THROWABLES;
        synchronized (set) {
            DISABLED_THROWABLES.add(clazz);
        }
        LOG.info("Logging " + clazz.getName() + " only to DEBUG log level.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reset() {
        Set<Class<? extends Throwable>> set = DISABLED_THROWABLES;
        synchronized (set) {
            if (!DISABLED_THROWABLES.isEmpty()) {
                DISABLED_THROWABLES.clear();
                LOG.info("Logging all messaged to default log level.");
            }
        }
    }
}

