/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.analysisComponent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.analysis.AnalysisController;
import kieker.analysis.IProjectContext;
import kieker.analysis.analysisComponent.IAnalysisComponent;
import kieker.analysis.exception.InvalidProjectContextException;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;

public abstract class AbstractAnalysisComponent
implements IAnalysisComponent {
    public static final String CONFIG_NAME = "name-hiddenAndNeverExportedProperty";
    protected static final Log LOG = LogFactory.getLog(AbstractAnalysisComponent.class);
    private static final AtomicInteger UNNAMED_COUNTER = new AtomicInteger(0);
    protected final IProjectContext projectContext;
    protected final Configuration configuration;
    protected final Log log;
    protected final TimeUnit recordsTimeUnitFromProjectContext;
    private final String name;

    public AbstractAnalysisComponent(Configuration configuration, IProjectContext projectContext) throws NullPointerException {
        TimeUnit recordTimeunit;
        if (null == projectContext) {
            throw new NullPointerException("Missing projectContext");
        }
        if (null == configuration) {
            throw new NullPointerException("Missing configuration");
        }
        this.projectContext = projectContext;
        configuration.setDefaultConfiguration(this.getDefaultConfiguration());
        this.configuration = configuration;
        if (!(projectContext instanceof AnalysisController)) {
            throw new InvalidProjectContextException("Invalid analysis controller in constructor");
        }
        AnalysisController ac = (AnalysisController)projectContext;
        String tmpName = configuration.getStringProperty(CONFIG_NAME);
        while (tmpName.length() == 0 || !ac.tryRegisterComponentName(tmpName)) {
            tmpName = this.getClass().getSimpleName() + '-' + UNNAMED_COUNTER.incrementAndGet();
        }
        this.name = tmpName;
        this.log = LogFactory.getLog(this.getClass().getName() + " (" + this.name + ")");
        String recordTimeunitProperty = projectContext.getProperty("recordsTimeUnit");
        try {
            recordTimeunit = TimeUnit.valueOf(recordTimeunitProperty);
        }
        catch (IllegalArgumentException ex) {
            this.log.warn(recordTimeunitProperty + " is no valid TimeUnit! Using NANOSECONDS instead.");
            recordTimeunit = TimeUnit.NANOSECONDS;
        }
        this.recordsTimeUnitFromProjectContext = recordTimeunit;
    }

    protected abstract Configuration getDefaultConfiguration();

    @Override
    public abstract Configuration getCurrentConfiguration();

    @Override
    public final String getName() {
        return this.name;
    }
}

