/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tooltip;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tooltip.Tooltip;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class TooltipRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Tooltip tooltip = (Tooltip)component;
        this.encodeMarkup(context, tooltip);
        this.encodeScript(context, tooltip);
    }

    protected void encodeMarkup(FacesContext context, Tooltip tooltip) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = tooltip.getStyleClass();
        styleClass = styleClass == null ? Tooltip.CONTAINER_CLASS : Tooltip.CONTAINER_CLASS + " " + styleClass;
        writer.startElement("div", (UIComponent)tooltip);
        writer.writeAttribute("id", (Object)tooltip.getClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (tooltip.getStyle() != null) {
            writer.writeAttribute("style", (Object)tooltip.getStyle(), "style");
        }
        if (tooltip.getChildCount() > 0) {
            this.renderChildren(context, (UIComponent)tooltip);
        } else {
            String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)tooltip);
            if (valueToRender != null) {
                writer.writeText((Object)valueToRender, "value");
            }
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Tooltip tooltip) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tooltip.getClientId(context);
        String target = this.getTarget(context, tooltip);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Tooltip','" + tooltip.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",target:'" + target + "'");
        if (tooltip.getShowEvent() != null) {
            writer.write(",showEvent:'" + tooltip.getShowEvent() + "'");
        }
        if (tooltip.getHideEvent() != null) {
            writer.write(",hideEvent:'" + tooltip.getHideEvent() + "'");
        }
        if (tooltip.getShowEffect() != null) {
            writer.write(",showEffect:'" + tooltip.getShowEffect() + "'");
        }
        if (tooltip.getHideEffect() != null) {
            writer.write(",hideEffect:'" + tooltip.getHideEffect() + "'");
        }
        writer.write("});});");
        this.endScript(writer);
    }

    protected String getTarget(FacesContext context, Tooltip tooltip) {
        String _for = tooltip.getFor();
        if (_for != null) {
            UIComponent forComponent = tooltip.findComponent(_for);
            if (forComponent == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return forComponent.getClientId(context);
        }
        throw new FacesException("No target is defined for tooltip '" + tooltip.getClientId(context) + "'");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

