/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.stack;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.stack.Stack;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class StackRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Stack stack = (Stack)component;
        if (stack.isDynamic()) {
            stack.buildMenuFromModel();
        }
        this.encodeMarkup(facesContext, stack);
        this.encodeScript(facesContext, stack);
    }

    protected void encodeScript(FacesContext facesContext, Stack stack) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = stack.getClientId(facesContext);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Stack','" + stack.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",openSpeed:" + stack.getOpenSpeed());
        writer.write(",closeSpeed:" + stack.getCloseSpeed());
        if (stack.isExpanded()) {
            writer.write(",expanded:true");
        }
        writer.write("},'stack');});");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext facesContext, Stack stack) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = stack.getClientId(facesContext);
        writer.startElement("div", (UIComponent)stack);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)"ui-stack", null);
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)this.getResourceURL(facesContext, stack.getIcon()), null);
        writer.endElement("img");
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)(clientId + "_stack"), "id");
        for (UIComponent child : stack.getChildren()) {
            if (!(child instanceof MenuItem) || !child.isRendered()) continue;
            this.encodeMenuItem(facesContext, (MenuItem)child);
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMenuItem(FacesContext context, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menuitem.getClientId(context);
        writer.startElement("li", null);
        writer.startElement("a", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (menuitem.getStyle() != null) {
            writer.writeAttribute("style", (Object)menuitem.getStyle(), null);
        }
        if (menuitem.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)menuitem.getStyleClass(), null);
        }
        if (menuitem.getUrl() != null) {
            writer.writeAttribute("href", (Object)this.getResourceURL(context, menuitem.getUrl()), null);
            if (menuitem.getOnclick() != null) {
                writer.writeAttribute("onclick", (Object)menuitem.getOnclick(), null);
            }
            if (menuitem.getTarget() != null) {
                writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
            }
        } else {
            writer.writeAttribute("href", (Object)"#", null);
            UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menuitem);
            if (form == null) {
                throw new FacesException("Stack must be inside a form element");
            }
            String command = menuitem.isAjax() ? this.buildAjaxRequest(context, menuitem, form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, form, clientId, true);
            command = menuitem.getOnclick() == null ? command : menuitem.getOnclick() + ";" + command;
            writer.writeAttribute("onclick", (Object)command, null);
        }
        writer.startElement("span", null);
        if (menuitem.getValue() != null) {
            writer.write((String)menuitem.getValue());
        }
        writer.endElement("span");
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)this.getResourceURL(context, menuitem.getIcon()), null);
        writer.endElement("img");
        writer.endElement("a");
        writer.endElement("li");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

