/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.socket;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.socket.Socket;
import org.primefaces.renderkit.CoreRenderer;

public class SocketRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Socket socket = (Socket)component;
        String channel = socket.getChannel();
        String channelUrl = "/primepush" + channel;
        String url = this.getResourceURL(context, channelUrl);
        String pushServer = context.getExternalContext().getInitParameter("primefaces.PUSH_SERVER_URL");
        if (pushServer != null) {
            url = pushServer + url;
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("$(function() {");
        writer.write(socket.resolveWidgetVar() + " = new PrimeFaces.widget.Socket({");
        writer.write("url:'" + url + "'");
        writer.write(",autoConnect:" + socket.isAutoConnect());
        writer.write(",transport:'" + socket.getTransport() + "'");
        writer.write(",fallbackTransport:'" + socket.getFallbackTransport() + "'");
        if (socket.getOnMessage() != null) {
            writer.write(",onMessage:" + socket.getOnMessage());
        }
        if (socket.getOnError() != null) {
            writer.write(",onError:" + socket.getOnError());
        }
        this.encodeClientBehaviors(context, socket);
        writer.write("});});");
        writer.endElement("script");
    }
}

