/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectonelistbox;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.primefaces.component.selectonelistbox.SelectOneListbox;
import org.primefaces.renderkit.SelectOneRenderer;

public class SelectOneListboxRenderer
extends SelectOneRenderer {
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return context.getRenderKit().getRenderer("javax.faces.SelectOne", "javax.faces.Listbox").getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectOneListbox listbox = (SelectOneListbox)component;
        this.encodeMarkup(context, listbox);
        this.encodeScript(context, listbox);
    }

    protected void encodeMarkup(FacesContext context, SelectOneListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = listbox.getClientId(context);
        String style = listbox.getStyle();
        String styleClass = listbox.getStyleClass();
        styleClass = styleClass == null ? "ui-selectonelistbox ui-inputfield ui-widget ui-widget-content ui-corner-all" : "ui-selectonelistbox ui-inputfield ui-widget ui-widget-content ui-corner-all " + styleClass;
        styleClass = listbox.isDisabled() ? styleClass + " ui-state-disabled" : styleClass;
        styleClass = !listbox.isValid() ? styleClass + " ui-state-error" : styleClass;
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeInput(context, listbox, clientId);
        this.encodeList(context, listbox);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectOneListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = listbox.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('SelectListbox','" + listbox.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",selection:'single'");
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)listbox);
        writer.write("});");
        this.endScript(writer);
    }

    protected void encodeInput(FacesContext context, SelectOneListbox listbox, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputid = clientId + "_input";
        writer.startElement("div", (UIComponent)listbox);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("select", (UIComponent)listbox);
        writer.writeAttribute("id", (Object)inputid, "id");
        writer.writeAttribute("name", (Object)inputid, null);
        writer.writeAttribute("size", (Object)"2", null);
        if (listbox.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)listbox.getTabindex(), null);
        }
        if (listbox.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)listbox.getOnchange(), null);
        }
        this.encodeSelectItems(context, listbox);
        writer.endElement("select");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, SelectOneListbox listbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", null);
        writer.endElement("ul");
    }

    protected void encodeSelectItems(FacesContext context, SelectOneListbox listbox) throws IOException {
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)listbox);
        Converter converter = listbox.getConverter();
        Object values = this.getValues((UISelectOne)listbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)listbox);
        for (SelectItem selectItem : selectItems) {
            this.encodeOption(context, listbox, selectItem, values, submittedValues, converter);
        }
    }

    protected void encodeOption(FacesContext context, SelectOneListbox listbox, SelectItem option, Object values, Object submittedValues, Converter converter) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)listbox, converter, option.getValue());
        boolean bl = disabled = option.isDisabled() || listbox.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)listbox, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("option", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (selected) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        writer.write(option.getLabel());
        writer.endElement("option");
    }

    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context) + "_input";
    }
}

