/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.imagecompare;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.imagecompare.ImageCompare;
import org.primefaces.renderkit.CoreRenderer;

public class ImageCompareRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ImageCompare compare = (ImageCompare)component;
        this.encodeMarkup(context, compare);
        this.encodeScript(context, compare);
    }

    protected void encodeScript(FacesContext context, ImageCompare compare) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = compare.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("PrimeFaces.cw('ImageCompare','" + compare.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",handle:'" + this.getResourceRequestPath(context, "imagecompare/handle.gif") + "'");
        writer.write(",lt:'" + this.getResourceRequestPath(context, "imagecompare/lt-small.png") + "'");
        writer.write(",rt:'" + this.getResourceRequestPath(context, "imagecompare/rt-small.png") + "'");
        writer.write("},'imagecompare');");
        this.endScript(writer);
    }

    protected void encodeMarkup(FacesContext context, ImageCompare compare) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)compare);
        writer.writeAttribute("id", (Object)compare.getClientId(context), "id");
        this.renderImage(context, compare, "before", compare.getLeftImage());
        this.renderImage(context, compare, "fter", compare.getRightImage());
        writer.endElement("div");
    }

    private void renderImage(FacesContext context, ImageCompare compare, String type, String src) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)compare);
        writer.startElement("img", null);
        writer.writeAttribute("alt", (Object)type, null);
        writer.writeAttribute("src", (Object)this.getResourceURL(context, src), null);
        writer.writeAttribute("width", (Object)compare.getWidth(), null);
        writer.writeAttribute("height", (Object)compare.getHeight(), null);
        writer.endElement("img");
        writer.endElement("div");
    }
}

