/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.editor;

import java.io.IOException;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.editor.Editor;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class EditorRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Editor editor = (Editor)component;
        String inputParam = editor.getClientId(context) + "_input";
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(inputParam);
        if (value != null && value.equals("<br/>")) {
            value = "";
        }
        editor.setSubmittedValue(value);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Editor editor = (Editor)component;
        this.encodeMarkup(facesContext, editor);
        this.encodeScript(facesContext, editor);
    }

    protected void encodeMarkup(FacesContext context, Editor editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = editor.getClientId(context);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)editor);
        String inputId = clientId + "_input";
        String style = editor.getStyle();
        style = style == null ? "visibility:hidden" : "visibility:hidden;" + style;
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("style", (Object)style, null);
        if (editor.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)editor.getStyleClass(), null);
        }
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        if (valueToRender != null) {
            writer.write(valueToRender);
        }
        writer.endElement("textarea");
        writer.endElement("div");
    }

    private void encodeScript(FacesContext facesContext, Editor editor) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = editor.getClientId(facesContext);
        String widgetVar = editor.resolveWidgetVar();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFaces.cw('Editor','" + widgetVar + "',{");
        writer.write("id:'" + clientId + "'");
        if (editor.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (!editor.isValid()) {
            writer.write(",invalid:true");
        }
        if (editor.getControls() != null) {
            writer.write(",controls:'" + editor.getControls() + "'");
        }
        if (editor.getWidth() != Integer.MIN_VALUE) {
            writer.write(",width:" + editor.getWidth());
        }
        if (editor.getHeight() != Integer.MIN_VALUE) {
            writer.write(",height:" + editor.getHeight());
        }
        if (editor.getOnchange() != null) {
            writer.write(",change:function(e){" + editor.getOnchange() + "}");
        }
        writer.write("},'editor');});");
        this.endScript(writer);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Editor editor = (Editor)component;
        String value = (String)submittedValue;
        Converter converter = editor.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)editor, value);
        }
        ValueExpression ve = editor.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(context.getELContext());
            Converter converterForType = context.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsObject(context, (UIComponent)editor, value);
            }
        }
        return value;
    }
}

